<?php
/**
 * Dynamic CSS File
 *
 * Dynamic css file for handling user options.
 *
 * @since    3.0.0
 * @package realhomes/common
 */
if ( ! function_exists( 'inspiry_generate_common_dynamic_css' ) ) {
	/**
	 * Function: Generate Dynamic CSS.
	 *
	 * @since 3.0.0
	 */
	function inspiry_generate_common_dynamic_css( $realhomes_common_custom_css ) {

		// Merging all dynamic css files returns
		$styles = array_merge(
			require( get_template_directory() . '/common/css/dynamic-css/currency-switcher.php' ),
			require( get_template_directory() . '/common/css/dynamic-css/language-switcher.php' ),
			require( get_template_directory() . '/common/css/dynamic-css/compare.php' ),
			require( get_template_directory() . '/common/css/dynamic-css/forms.php' )
		);

		// Google reCaptcha show/hide control
		if ( 'hide' === get_option( 'ere_display_recaptcha_badge', 'show' ) ) {
			$styles[] = array(
				'elements' => '.grecaptcha-badge',
				'property' => 'visibility',
				'value'    => 'hidden !important'
			);
		}

		// Logo width control option
		if ( ! empty( get_option( 'realhomes_header_logo_width', '' ) ) ) {
			$styles[] = array(
				'elements' => '.rh-ultra-logo a',
				'property' => 'display',
				'value'    => 'inline-block'
			);

			$header_width = get_option( 'realhomes_header_logo_width', '' );

			if ( ! empty( $header_width ) && is_numeric( $header_width ) ) {
				// Sanitize the value to ensure it's a positive integer
				$header_width = absint( $header_width );

				$styles[] = array(
					'elements' => '.rh_logo_wrapper img, .rh-ultra-logo a, .rh-ultra-logo img, #header #logo .site-logo img',
					'property' => 'width',
					'value'    => esc_html( $header_width ) . 'px'
				);
			}
		}

		if ( 0 < count( $styles ) ) {
			foreach ( $styles as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$realhomes_common_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
				}
			}
		}


		// Responsive Portion starting from here
		$responsive_keys = array(
			'theme_floating_responsive_background',
			'inspiry_floating_position'
		);

		$responsive_options_array = realhomes_get_options( $responsive_keys );

		$styles_min_891   = array();
		if ( ! empty( $responsive_options_array[ 'inspiry_floating_position' ] ) ) {
			$styles_min_891[] = array(
				'elements' => 'div.rh_wrapper_floating_features',
				'property' => 'top',
				'value'    => $responsive_options_array[ 'inspiry_floating_position' ]
			);
		}

		if ( ! empty( $styles_min_891 ) ) {
			$realhomes_common_custom_css .= "@media ( min-width: 891px ) {\n";
			foreach ( $styles_min_891 as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$realhomes_common_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
				}
			}
			$realhomes_common_custom_css .= "}\n";
		}

		$styles_max_890 = array();
		if ( ! empty( $responsive_options_array[ 'theme_floating_responsive_background' ] ) ) {
			$styles_max_890[] = array(
				'elements' => '.rh_wrapper_floating_features',
				'property' => 'background',
				'value'    => $responsive_options_array[ 'theme_floating_responsive_background' ],
			);
		}

		if ( ! empty( $styles_max_890 ) ) {
			$realhomes_common_custom_css .= "@media ( max-width: 890px ) {\n";
			foreach ( $styles_max_890 as $css_unit ) {
				if ( ! empty( $css_unit['value'] ) ) {
					$realhomes_common_custom_css .= strip_tags( $css_unit['elements'] . " { " . $css_unit['property'] . " : " . $css_unit['value'] . ";" . " }\n" );
				}
			}
			$realhomes_common_custom_css .= "}\n";
		}

		// Returning the processed CSS
		return $realhomes_common_custom_css;
	}
}
add_filter( 'realhomes_common_custom_css', 'inspiry_generate_common_dynamic_css' );

if ( ! function_exists( 'output_quick_css' ) ) {
	/**
	 * Output Quick CSS Fix
	 */
	function output_quick_css( $realhomes_common_custom_css ) {
		// Quick CSS from Theme Options
		$quick_css = stripslashes( get_option( 'theme_quick_css' ) );
		if ( ! empty( $quick_css ) ) {
			$realhomes_common_custom_css .= "\n";
			$realhomes_common_custom_css .= strip_tags( $quick_css );
		}

		return $realhomes_common_custom_css;
	}
}
add_filter( 'realhomes_common_custom_css', 'output_quick_css' );

if ( ! function_exists( 'inspiry_property_features_icons_css' ) ) {
	/**
	 * Generate CSS Style for property features icons.
	 *
	 * @since 3.10
	 */
	function inspiry_property_features_icons_css( $realhomes_common_custom_css ) {
		if ( ! is_singular( 'property' ) ) {
			return $realhomes_common_custom_css;
		}

		$features_terms = get_the_terms( get_the_ID(), 'property-feature' );
		if ( empty( $features_terms ) ) {
			return $realhomes_common_custom_css;
		}

		$css = '';

		foreach ( $features_terms as $feature_term ) {
			$term_id         = $feature_term->term_id;
			$feature_icon_id = get_term_meta( $feature_term->term_id, 'inspiry_property_feature_icon', true );
			$feature_icon    = ! empty( $feature_icon_id ) ? wp_get_attachment_url( $feature_icon_id ) : false;

			if ( empty( $feature_icon ) ) {
				continue;
			}

			if ( 'modern' === INSPIRY_DESIGN_VARIATION ) {
				$css .= "
						.rh_property__features_wrap #rh_property__feature_{$term_id} .rh_done_icon{
							display: none;
						}
						
						.rh_property__features_wrap #rh_property__feature_{$term_id}:before{
						    content: '';
							position: relative;
							display: block;
							width: 14px;
							height: 14px;
							background: url('{$feature_icon}') no-repeat;
							background-size: 14px; 
						";
				$css .= is_rtl() ? "margin: 0 -20px 0 5px;" : "margin: 0 5px 0 -20px;";
				$css .= "}\n";
			} else if ( 'classic' === INSPIRY_DESIGN_VARIATION ) {
				$css .= "
						#overview .property-item .features #rh_property__feature_{$term_id}:before{
							background: url('{$feature_icon}') no-repeat center center;
							background-size: 20px;
						}
						";
			}
		}

		$realhomes_common_custom_css .= $css;

		return $realhomes_common_custom_css;
	}
}
add_filter( 'realhomes_common_custom_css', 'inspiry_property_features_icons_css' );