<?php
/**
 * Containing dynamic css footer style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage ultra
 */

$footer_keys = array(
	'inspiry_footer_bg',
	'theme_footer_widget_text_color',
	'theme_footer_widget_text_color',
	'theme_footer_widget_link_hover_color',
	'theme_footer_widget_title_hover_color',
	'realhomes_footer_contacts_wrapper_bg_color',
	'realhomes_footer_contacts_heading_color',
	'realhomes_footer_contacts_button_color',
	'realhomes_footer_contacts_button_hover_color',
	'realhomes_footer_contacts_button_color',
	'realhomes_footer_contacts_button_hover_color',
	'realhomes_footer_contacts_button_bg_color',
	'realhomes_footer_contacts_button_bg_hover_color'
);

$footer_options = realhomes_get_options( $footer_keys );

$footer_css[] = array(
	'elements' => '.site-footer',
	'property' => 'background-color',
	'value'    => $footer_options['inspiry_footer_bg']
);
$footer_css[] = array(
	'elements' => '.site-footer',
	'property' => 'color',
	'value'    => $footer_options['theme_footer_widget_text_color']
);
$footer_css[] = array(
	'elements' => '.site-footer a',
	'property' => 'color',
	'value'    => $footer_options['theme_footer_widget_text_color']
);
$footer_css[] = array(
	'elements' => '.site-footer a:hover',
	'property' => 'color',
	'value'    => $footer_options['theme_footer_widget_link_hover_color']
);
$footer_css[] = array(
	'elements' => '.site-footer h1, .site-footer h2, .site-footer h3, .site-footer h4, .site-footer h5, .site-footer h6',
	'property' => 'color',
	'value'    => $footer_options['theme_footer_widget_title_hover_color']
);
$footer_css[] = array(
	'elements' => '.site-footer-contacts',
	'property' => 'background-color',
	'value'    => $footer_options['realhomes_footer_contacts_wrapper_bg_color']
);
$footer_css[] = array(
	'elements' => '.site-footer-contacts .rh-ultra-footer-help',
	'property' => 'color',
	'value'    => $footer_options['realhomes_footer_contacts_heading_color']
);
$footer_css[] = array(
	'elements' => '.site-footer .rh-ultra-footer-number',
	'property' => 'color',
	'value'    => $footer_options['realhomes_footer_contacts_button_color']
);
$footer_css[] = array(
	'elements' => '.site-footer .rh-ultra-footer-number:hover',
	'property' => 'color',
	'value'    => $footer_options['realhomes_footer_contacts_button_hover_color']
);
$footer_css[] = array(
	'elements' => '.site-footer .rh-ultra-footer-number svg',
	'property' => 'fill',
	'value'    => $footer_options['realhomes_footer_contacts_button_color']
);
$footer_css[] = array(
	'elements' => '.site-footer .rh-ultra-footer-number:hover svg',
	'property' => 'fill',
	'value'    => $footer_options['realhomes_footer_contacts_button_hover_color']
);
$footer_css[] = array(
	'elements' => '.site-footer .rh-ultra-footer-number',
	'property' => array( 'background-color' ),
	'value'    => $footer_options['realhomes_footer_contacts_button_bg_color']
);
$footer_css[] = array(
	'elements' => '.site-footer .rh-ultra-footer-number:hover',
	'property' => array( 'background-color' ),
	'value'    => $footer_options['realhomes_footer_contacts_button_bg_hover_color']
);

return $footer_css;