<?php
/**
 * Display RVR section if enabled.
 *
 * @package    realhomes
 * @subpackage ultra
 */
if ( inspiry_is_rvr_enabled() && ( 'true' === get_option( 'realhomes_rvr_surroundings', 'true' ) || 'true' === get_option( 'realhomes_rvr_outdoor_features', 'true' ) ) ) {
	?>
    <div class="rh_wrapper_rvr_features <?php realhomes_printable_section( 'rvr/location-surroundings' ); ?>">
		<?php
		$property_id           = get_the_ID();
		$location_surroundings = get_post_meta( $property_id, 'rvr_surroundings', true );
		$rvr_outdoor_features  = get_post_meta( $property_id, 'rvr_outdoor_features', true );
		if ( ! empty( $location_surroundings ) || ! empty( $rvr_outdoor_features ) ) {
			?>
            <div class="rh_rvr_alternate_wrapper rh_outdoor_and_surroundings">
				<?php
				// RVR - Property Location Surroundings.
				get_template_part( 'assets/modern/partials/property/single/rvr/surroundings' );

				// RVR - Property Outdoor Features.
				get_template_part( 'assets/ultra/partials/property/single/rvr/outdoor-features' );
				?>
            </div>
			<?php
		}
		?>
    </div>
	<?php
}