<div class="rh-ultra-thumb-info-box">
    <div class="page-head-inner">
        <div class="rh-ultra-property-tags rh-property-title">
			<?php
            $property_id = get_the_ID();

			if ( function_exists( 'ere_get_property_tags' ) ) {
				ere_get_property_tags( $property_id, 'rh-ultra-status rh-ultra-property-tag' );
				ere_get_property_tags( $property_id, 'rh-ultra-type rh-ultra-property-tag', 'property-type' );
			}

			$is_featured = get_post_meta( $property_id, 'REAL_HOMES_featured', true );
			if ( $is_featured ) {
				?>
                <span class="rh_ultra_featured rh-ultra-property-tag"><?php esc_html_e( 'Featured', RH_TEXT_DOMAIN ); ?></span>
				<?php
			}
			inspiry_display_property_label( $property_id, 'rh-ultra-label rh-ultra-property-tag' );
			?>
        </div>
        <div class="rh-ultra-property-title-price">
			<?php
			if ( isset( $args['print'] ) && 'true' === $args['print'] ) {
				?>
                <span class="property-title"><?php the_title(); ?></span>
				<?php
			} else {
				?>
                <h1 class="property-title"><?php the_title(); ?></h1>
				<?php
			}

			if ( function_exists( 'ere_property_price' ) ) {
				?>
                <div class="rh-ultra-property-tag-wrapper">
					<?php
					$amount             = floatval( get_post_meta( $property_id, 'REAL_HOMES_property_price', true ) );
					$price_wrap_classes = ( empty( $amount ) || is_nan( $amount ) ) ? ' price-on-call ' : '';
					$price_wrap_classes .= realhomes_is_dual_price_enabled( $property_id ) ? 'dual-price' : '';
					?>
                    <span class="rh-ultra-price <?php echo esc_attr( $price_wrap_classes ); ?>">
                        <?php ere_property_price( $property_id, true ); ?>
                    </span>
                </div>
				<?php
			}
			?>
        </div>
		<?php
		$address_display  = get_option( 'inspiry_display_property_address', 'true' );
		$property_address = get_post_meta( $property_id, 'REAL_HOMES_property_address', true );

		if ( 'true' === $address_display && ! empty( $property_address ) ) {
			?>
            <p class="rh-ultra-property-address">
                <span class="rh-ultra-address-pin"><?php inspiry_safe_include_svg( '/ultra/icons/pin-line.svg', '/assets/' ); ?></span>
				<?php echo esc_html( $property_address ); ?>
            </p>
			<?php
		}
		?>
    </div>
</div>