<?php
/**
 * Property meta of single property template.
 *
 * @since      4.0.0
 * @package    realhomes
 * @subpackage ultra
 */

global $post;

$post_id        = get_the_ID();
$post_meta_data = get_post_custom( $post_id );

$meta_to_display = array(
	'bedrooms'   => [
		'id'       => 'REAL_HOMES_property_bedrooms',
		'label'    => 'inspiry_bedrooms_field_label',
		'default'  => esc_html__( 'Bedrooms', RH_TEXT_DOMAIN ),
		'icon'     => 'ultra-bedrooms.svg',
		'post-fix' => ''
	],
	'bathrooms'  => [
		'id'       => 'REAL_HOMES_property_bathrooms',
		'label'    => 'inspiry_bathrooms_field_label',
		'default'  => esc_html__( 'Bathrooms', RH_TEXT_DOMAIN ),
		'icon'     => 'ultra-bathrooms.svg',
		'post-fix' => ''
	],
	'garage'     => [
		'id'       => 'REAL_HOMES_property_garage',
		'label'    => 'inspiry_garages_field_label',
		'default'  => esc_html__( 'Garage', RH_TEXT_DOMAIN ),
		'icon'     => 'garage.svg',
		'post-fix' => ''
	],
	'year-built' => [
		'id'       => 'REAL_HOMES_property_year_built',
		'label'    => 'inspiry_year_built_field_label',
		'default'  => esc_html__( 'Year Built', RH_TEXT_DOMAIN ),
		'icon'     => 'calendar.svg',
		'post-fix' => ''
	],
	'area'       => [
		'id'       => 'REAL_HOMES_property_size',
		'label'    => 'inspiry_area_field_label',
		'default'  => esc_html__( 'Area', RH_TEXT_DOMAIN ),
		'icon'     => 'ultra-area.svg',
		'post-fix' => 'REAL_HOMES_property_size_postfix'
	],
	'lot-size'   => [
		'id'       => 'REAL_HOMES_property_lot_size',
		'label'    => 'inspiry_lot_size_field_label',
		'default'  => esc_html__( 'Lot Size', RH_TEXT_DOMAIN ),
		'icon'     => 'ultra-lot-size.svg',
		'post-fix' => 'REAL_HOMES_property_lot_size_postfix'
	],
);

if ( inspiry_is_rvr_enabled() ) {
	$rvr_meta_to_display = array(
		'guests'   => [
			'id'       => 'rvr_guests_capacity',
			'label'    => 'inspiry_rvr_guests_field_label',
			'default'  => esc_html__( 'Capacity', RH_TEXT_DOMAIN ),
			'icon'     => 'ultra-guests.svg',
			'post-fix' => ''
		],
		'min-stay' => [
			'id'       => 'rvr_min_stay',
			'label'    => 'inspiry_rvr_min_stay_label',
			'default'  => esc_html__( 'Min Stay', RH_TEXT_DOMAIN ),
			'icon'     => 'ultra-min-stay.svg',
			'post-fix' => ''
		],
	);

	$meta_to_display = array_merge( $meta_to_display, $rvr_meta_to_display );
}

$default_order = array( 'bedrooms', 'bathrooms', 'area' );
$user_order    = get_option( 'inspiry_property_card_meta', $default_order );
$user_order    = array_filter( (array)$user_order );

$sorted = [];
foreach ( $user_order as $slug ) {
	if ( isset( $meta_to_display[ $slug ] ) ) {
		$sorted[] = $meta_to_display[ $slug ];
	}
}

if ( empty( $sorted ) ) {
	return;
}

$meta_to_display = $sorted;
$meta_to_display = apply_filters( 'inspiry_property_detail_meta', $meta_to_display );
?>
<div class="rh_ultra_prop_card_meta_wrap margin-bottom-40px">
	<?php
	foreach ( $meta_to_display as $value ) {
		if ( ! empty( $post_meta_data[ $value['id'] ][0] ) ) {
			?>
            <div class="rh_ultra_prop_card__meta">
                <div class="rh_ultra_meta_icon_wrapper">
                    <span class="rh-ultra-meta-label">
                        <?php
                        $label = get_option( $value['label'] );
                        echo ( empty ( $label ) ) ? $value['default'] : esc_html( $label );
                        ?>
                    </span>
                    <div class="rh-ultra-meta-icon-wrapper">
                        <span class="rh_ultra_meta_icon">
                            <?php realhomes_property_meta_icon( $value['id'], '/ultra/icons/' . $value['icon'], '/assets/' ); ?>
                        </span>
                        <span class="rh_ultra_meta_box">
                            <span class="figure"><?php echo esc_html( $post_meta_data[ $value['id'] ][0] ); ?></span>
                            <?php
                            if ( ! empty( $value['post-fix'] ) ) {
	                            $pf = $value['post-fix'];
	                            if ( 'REAL_HOMES_property_size_postfix' === $pf ) {
		                            $get_postfix = realhomes_get_area_unit( $post_id );
	                            } else if ( 'REAL_HOMES_property_lot_size_postfix' === $pf ) {
		                            $get_postfix = realhomes_get_lot_unit( $post_id );
	                            } else {
		                            $get_postfix = get_post_meta( $post_id, $pf, true );
	                            }
	                            echo '<span class="label">' . esc_html( $get_postfix ) . '</span>';
                            }
                            ?>
                        </span>
                    </div>
                </div>
            </div>
			<?php
		}
	}

	/**
	 * This hook can be used to display more property meta fields
	 */
	do_action( 'inspiry_additional_property_meta_fields', $post_id );
	?>
</div><!-- /.rh_property__row rh_property__meta -->