<?php
/**
 * Containing dynamic css properties style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

$properties_styles_keys = array(
	array( 'inspiry_grid_card_featured_tag_bg_color', '#1ea69a' ),
	array( 'inspiry_grid_card_featured_tag_color', '#ffffff' ),
	array( 'inspiry_grid_card_trend_tag_bg_color', '#d22d3e' ),
	array( 'inspiry_grid_card_trend_tag_color', '#ffffff' ),
	array( 'inspiry_grid_card_status_tag_bg_color', '#000' ),
	array( 'inspiry_grid_card_status_tag_color', '#fff' ),
	array( 'inspiry_grid_card_2_bottom_agent_title', '#fff' ),
	array( 'inspiry_grid_card_2_bottom_agent_hover_title', '#f7f7f7' ),
	array( 'inspiry_grid_card_2_bottom_agency_title', '#fff' ),
	array( 'inspiry_grid_card_2_bottom_agency_hover_title', '#f7f7f7' ),
	array( 'inspiry_grid_card_3_bottom_agent_bg', '#f7f7f7' ),
	array( 'inspiry_grid_card_3_bottom_agent_title', '#1a1a1a' ),
	array( 'inspiry_grid_card_3_bottom_agent_hover_title', '#1a1a1a' ),
	array( 'inspiry_grid_card_3_bottom_agency_title', '#808080' ),
	array( 'inspiry_grid_card_3_bottom_agency_hover_title', '#1a1a1a' ),
	array( 'realhomes_grid_card_4_status_tag_bg_color', '#0b8278' ),
	array( 'realhomes_grid_card_4_status_tag_color', '#fff' ),
	array( 'realhomes_grid_card_4_price_color', '#fff' ),
	array( 'realhomes_grid_card_5_status_tag_bg_color', '#0b8278' ),
	array( 'realhomes_grid_card_5_status_tag_color', '#fff' ),
	array( 'realhomes_grid_card_5_title_color', '#fff' ),
	array( 'realhomes_grid_card_5_price_color', '#fff' ),
	array( 'realhomes_grid_card_5_meta_color', '#fff' )
);

$properties_style_options = realhomes_get_options( $properties_styles_keys );

$grid_card_featured_tag_bg_color       = $properties_style_options['inspiry_grid_card_featured_tag_bg_color'];
$grid_card_featured_tag_color          = $properties_style_options['inspiry_grid_card_featured_tag_color'];
$grid_card_trend_tag_bg_color          = $properties_style_options['inspiry_grid_card_trend_tag_bg_color'];
$grid_card_trend_tag_color             = $properties_style_options['inspiry_grid_card_trend_tag_color'];
$grid_card_status_tag_bg_color         = $properties_style_options['inspiry_grid_card_status_tag_bg_color'];
$grid_card_status_tag_color            = $properties_style_options['inspiry_grid_card_status_tag_color'];
$grid_card_2_bottom_agent_title        = $properties_style_options['inspiry_grid_card_2_bottom_agent_title'];
$grid_card_2_bottom_agent_hover_title  = $properties_style_options['inspiry_grid_card_2_bottom_agent_hover_title'];
$grid_card_2_bottom_agency_title       = $properties_style_options['inspiry_grid_card_2_bottom_agency_title'];
$grid_card_2_bottom_agency_hover_title = $properties_style_options['inspiry_grid_card_2_bottom_agency_hover_title'];
$grid_card_3_bottom_agent_bg           = $properties_style_options['inspiry_grid_card_3_bottom_agent_bg'];
$grid_card_3_bottom_agent_title        = $properties_style_options['inspiry_grid_card_3_bottom_agent_title'];
$grid_card_3_bottom_agent_hover_title  = $properties_style_options['inspiry_grid_card_3_bottom_agent_hover_title'];
$grid_card_3_bottom_agency_title       = $properties_style_options['inspiry_grid_card_3_bottom_agency_title'];
$grid_card_3_bottom_agency_hover_title = $properties_style_options['inspiry_grid_card_3_bottom_agency_hover_title'];
$grid_card_4_status_tag_bg_color       = $properties_style_options['realhomes_grid_card_4_status_tag_bg_color'];
$grid_card_4_status_tag_color          = $properties_style_options['realhomes_grid_card_4_status_tag_color'];
$grid_card_4_price_color               = $properties_style_options['realhomes_grid_card_4_price_color'];
$grid_card_5_status_tag_bg_color       = $properties_style_options['realhomes_grid_card_5_status_tag_bg_color'];
$grid_card_5_status_tag_color          = $properties_style_options['realhomes_grid_card_5_status_tag_color'];
$grid_card_5_title_color               = $properties_style_options['realhomes_grid_card_5_title_color'];
$grid_card_5_price_color               = $properties_style_options['realhomes_grid_card_5_price_color'];
$grid_card_5_meta_color                = $properties_style_options['realhomes_grid_card_5_meta_color'];


return array(
	array(
		'elements' => '.rh_latest_properties_2 .rh_tags_wrapper .rh_featured:before',
		'property' => 'border-color',
		'value'    => $grid_card_featured_tag_bg_color
	),
	array(
		'elements' => '.rh_latest_properties_2 .rh_tags_wrapper .rh_featured:before',
		'property' => 'border-bottom-color',
		'value'    => 'transparent',
	),
	array(
		'elements' => '.rh_latest_properties_2 .rh_tags_wrapper .rh-tags svg',
		'property' => 'fill',
		'value'    => $grid_card_featured_tag_color
	),
	array(
		'elements' => '.rh_latest_properties_2 .rh_tags_wrapper .rh_hot:before',
		'property' => 'border-color',
		'value'    => $grid_card_trend_tag_bg_color
	),
	array(
		'elements' => '.rh_latest_properties_2 .rh_tags_wrapper .rh_hot:before',
		'property' => 'border-bottom-color',
		'value'    => 'transparent',
	),
	array(
		'elements' => '.rh_latest_properties_2 .rh_tags_wrapper .rh-tags:not(.rh_featured) svg',
		'property' => 'fill',
		'value'    => $grid_card_trend_tag_color
	),
	array(
		'elements' => '.rh_prop_status_sty',
		'property' => 'background-color',
		'value'    => $grid_card_status_tag_bg_color
	),
	array(
		'elements' => '.rh_prop_status_sty',
		'property' => 'color',
		'value'    => $grid_card_status_tag_color
	),
	array(
		'elements' => '.rh_agent_expand_wrapper .rh_agent_list .rh_agent_agency .rh_property_agent__title',
		'property' => 'color',
		'value'    => $grid_card_2_bottom_agent_title
	),
	array(
		'elements' => '.rh_agent_expand_wrapper .rh_agent_list .rh_agent_agency .rh_property_agent__title:hover',
		'property' => 'color',
		'value'    => $grid_card_2_bottom_agent_hover_title
	),
	array(
		'elements' => '.rh_agent_expand_wrapper .rh_agent_list .rh_agent_agency .rh_property_agent__agency',
		'property' => 'color',
		'value'    => $grid_card_2_bottom_agency_title
	),
	array(
		'elements' => '.rh_agent_expand_wrapper .rh_agent_list .rh_agent_agency .rh_property_agent__agency:hover',
		'property' => 'color',
		'value'    => $grid_card_2_bottom_agency_hover_title
	),
	array(
		'elements' => '.rh_wrapper_bottom_agent .rh_agent_expand_wrapper',
		'property' => 'background',
		'value'    => $grid_card_3_bottom_agent_bg
	),
	array(
		'elements' => '.rh_wrapper_bottom_agent .rh_agent_expand_wrapper .rh_agent_list .rh_property_agent__title',
		'property' => 'color',
		'value'    => $grid_card_3_bottom_agent_title
	),
	array(
		'elements' => '.rh_wrapper_bottom_agent .rh_agent_expand_wrapper .rh_agent_list .rh_property_agent__title:hover',
		'property' => 'color',
		'value'    => $grid_card_3_bottom_agent_hover_title
	),
	array(
		'elements' => '.rh_wrapper_bottom_agent .rh_agent_expand_wrapper .rh_agent_list .rh_property_agent__agency',
		'property' => 'color',
		'value'    => $grid_card_3_bottom_agency_title
	),
	array(
		'elements' => '.rh_wrapper_bottom_agent .rh_agent_expand_wrapper .rh_agent_list .rh_property_agent__agency:hover',
		'property' => 'color',
		'value'    => $grid_card_3_bottom_agency_hover_title
	),
	array(
		'elements' => '.rh-grid-card-4 .rh-status-property-tag',
		'property' => 'background-color',
		'value'    => $grid_card_4_status_tag_bg_color
	),
	array(
		'elements' => '.rh-grid-card-4 .rh-status-property-tag',
		'property' => 'color',
		'value'    => $grid_card_4_status_tag_color
	),
	array(
		'elements' => '.rh-grid-card-4 .rh_prop_card__price',
		'property' => 'color',
		'value'    => $grid_card_4_price_color
	),
	array(
		'elements' => '.rh-grid-card-5 .rh-status-property-tag',
		'property' => 'background-color',
		'value'    => $grid_card_5_status_tag_bg_color
	),
	array(
		'elements' => '.rh-grid-card-5 .rh-status-property-tag',
		'property' => 'color',
		'value'    => $grid_card_5_status_tag_color
	),
	array(
		'elements' => '.rh-grid-card-5 .rh-property-title',
		'property' => 'color',
		'value'    => $grid_card_5_title_color
	),
	array(
		'elements' => '.rh-grid-card-5 .rh-property-price',
		'property' => 'color',
		'value'    => $grid_card_5_price_color
	),
	array(
		'elements' => '.rh-grid-card-5 .rh_prop_card_meta_theme_stylish .rh_prop_card__meta .figure',
		'property' => 'color',
		'value'    => $grid_card_5_meta_color
	),
	array(
		'elements' => '
			.rh-grid-card-5 .rh_prop_card_meta_theme_stylish .rh_prop_card__meta svg,
			.rh-grid-card-5 .rh_prop_card_meta_theme_stylish .rh_prop_card__meta path,
			.rh-grid-card-5 .rh_prop_card_meta_theme_stylish .rh_prop_card__meta circle,
			.rh-grid-card-5 .rh_prop_card_meta_theme_stylish .rh_prop_card__meta .label
		',
		'property' => 'fill',
		'value'    => $grid_card_5_meta_color
	)
);