<?php
/**
 * Containing dynamic css miscellaneous style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

$mise_styles_keys = array(
	'realhomes_rating_stars_color',
	'realhomes_unrated_stars_color',
	'realhomes_rating_percentage_inactive_color',
	'realhomes_rating_percentage_active_color',
	array( 'inspiry_stp_position_from_bottom', '40px' )
);

$misc_style_options = realhomes_get_options( $mise_styles_keys );

$rating_stars_color               = $misc_style_options['realhomes_rating_stars_color'];
$unrated_stars_color              = $misc_style_options['realhomes_unrated_stars_color'];
$rating_percentage_inactive_color = $misc_style_options['realhomes_rating_percentage_inactive_color'];
$rating_percentage_active_color   = $misc_style_options['realhomes_rating_percentage_active_color'];
$stp_position_from_bottom         = $misc_style_options['inspiry_stp_position_from_bottom'];

$misc_styles_array = array(
	array(
		'elements' => '
			.rating-stars i.rated,
			.design_modern .rhea_rvr_ratings_wrapper_stylish .rating-stars i.rated,
			.design_modern .br-theme-fontawesome-stars .br-widget a.br-selected,
			.design_modern .br-theme-fontawesome-stars .br-widget a.br-selected:after,
			.design_modern .br-theme-fontawesome-stars .br-widget a.active,
			.design_modern .br-theme-fontawesome-stars .br-widget a.active:after
		',
		'property' => 'color',
		'value'    => $rating_stars_color
	),
	array(
		'elements' => '
			.rating-stars i,
			.design_modern .rhea_rvr_ratings_wrapper_stylish .rating-stars i,
			.design_modern .br-theme-fontawesome-stars .br-widget a,
			.design_modern .br-theme-fontawesome-stars .br-widget a:after
		',
		'property' => 'color',
		'value'    => $unrated_stars_color
	),
	array(
		'elements' => '
			body.design_modern .inspiry_stars_avg_rating .inspiry_rating_percentage .inspiry_rating_line,
			body.design_modern .rh_stars_avg_rating .rh_rating_percentage .rh_rating_line
		',
		'property' => 'background-color',
		'value'    => $rating_percentage_inactive_color
	),
	array(
		'elements' => '
			body.design_modern .inspiry_stars_avg_rating .inspiry_rating_percentage .inspiry_rating_line .inspiry_rating_line_inner,
			body.design_modern .rh_stars_avg_rating .rh_rating_percentage .rh_rating_line .rh_rating_line_inner
		',
		'property' => 'background-color',
		'value'    => $rating_percentage_active_color
	)
);

if ( ! empty( $stp_position_from_bottom ) ) {
	$misc_styles_array[] = array(
		'elements' => '#scroll-top',
		'property' => 'bottom',
		'value'    => $stp_position_from_bottom,
	);
}

return $misc_styles_array;