<?php
/**
 * Containing dynamic css headings style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

$heading_styles_keys = array(
	'inspiry_heading_font_color'
);

$heading_style_options = realhomes_get_options( $heading_styles_keys );
$heading_font_color    = $heading_style_options['inspiry_heading_font_color'];
$heading_style_array   = array();

if ( $heading_font_color ) {
	$heading_style_array[] = array(
		'elements' => '
			h1, h2, h3, h4, h5, h6, .rh_logo .rh_logo__heading a,
			.rh_user .rh_user__details .rh_user__msg,
			.rh_slide__desc h3 .title, .rh_section .rh_section__head .rh_section__subtitle,
			.rh_page__head .rh_page__title .title, .rh_modal .rh_modal__wrap .rh_modal__dashboard .rh_modal__dash_link,
			.rh_page__head .rh_page__title .sub,
			.rh_page__head .rh_page__title .sub, .rh_agent_card__wrap .rh_agent_card__head .rh_agent_card__name .name a,
			body .rh_prop_card__details_elementor h3 a,
			body .rh_section__agents_elementor .rh_agent_elementor .rh_agent__details h3 a,
			body .classic_properties_elementor_wrapper .rhea_property_title a,
			.rh_prop_card .rh_prop_card__details h3 a,
			.property-thumbnail .property-title a
		',
		'property' => 'color',
		'value'    => $heading_font_color,
	);
}

return $heading_style_array;