<?php
/**
 * Containing dynamic css header style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */
global $dynamic_css;

$header_styles_keys = array(
	'theme_header_bg_color',
	'theme_header_menu_top_color',
	'theme_header_meta_bg_color',
	'theme_main_menu_text_color',
	'theme_main_menu_text_hover_color',
	'inspiry_top_menu_gradient_color',
	'inspiry_main_menu_hover_bg',
	array( 'theme_menu_bg_color', '#fff' ),
	array( 'theme_menu_text_color', '#808080' ),
	'theme_menu_hover_bg_color',
	'theme_menu_hover_text_color',
	array( 'theme_phone_text_color', '#ffffff' ),
	array( 'theme_phone_text_color_hover', '#ffffff' ),
	'theme_header_social_icon_color',
	'theme_header_social_icon_color_hover',
	'theme_modern_sticky_header_bg_color',
	'theme_modern_sticky_header_menu_color',
	'theme_modern_sticky_header_menu_hover_color',
	'theme_modern_sticky_header_menu_text_hover_color',
	'theme_modern_sticky_header_btn_color',
	'theme_modern_sticky_header_btn_hover_color',
	'theme_modern_sticky_header_btn_text_color',
	'theme_modern_sticky_header_btn_hover_text_color',
	'theme_modern_sticky_header_site_title_color',
	'theme_modern_sticky_header_site_title_hover_color',
	array( 'theme_logo_text_color', '#fff' ),
	array( 'theme_logo_text_hover_color', '#1ea69a' )
);

$header_style_options = realhomes_get_options( $header_styles_keys );

// Header
$theme_header_bg_color            = $header_style_options['theme_header_bg_color'];
$theme_header_menu_top_color      = $header_style_options['theme_header_menu_top_color'];
$theme_header_meta_bg_color       = $header_style_options['theme_header_meta_bg_color'];
$theme_main_menu_text_color       = $header_style_options['theme_main_menu_text_color'];
$theme_main_menu_text_hover_color = $header_style_options['theme_main_menu_text_hover_color'];
$inspiry_top_menu_gradient_color  = $header_style_options['inspiry_top_menu_gradient_color'];

if ( ! empty( $inspiry_top_menu_gradient_color ) ) {
	$gradient_staring = inspiry_hex_to_rgba( $inspiry_top_menu_gradient_color, .7 );
} else {
	$gradient_staring = 'rgba(0, 0, 0, 0.7)';
}

$inspiry_main_menu_hover_bg           = $header_style_options['inspiry_main_menu_hover_bg'];
$theme_menu_bg_color                  = $header_style_options['theme_menu_bg_color'];
$theme_menu_text_color                = $header_style_options['theme_menu_text_color'];
$theme_menu_hover_bg_color            = $header_style_options['theme_menu_hover_bg_color'];
$theme_menu_hover_text_color          = $header_style_options['theme_menu_hover_text_color'];
$theme_phone_text_color               = $header_style_options['theme_phone_text_color'];
$theme_phone_text_color_hover         = $header_style_options['theme_phone_text_color_hover'];
$theme_header_social_icon_color       = $header_style_options['theme_header_social_icon_color'];
$theme_header_social_icon_color_hover = $header_style_options['theme_header_social_icon_color_hover'];

// sticky Header
$theme_modern_sticky_header_bg_color               = $header_style_options['theme_modern_sticky_header_bg_color'];
$theme_modern_sticky_header_menu_color             = $header_style_options['theme_modern_sticky_header_menu_color'];
$theme_modern_sticky_header_menu_hover_color       = $header_style_options['theme_modern_sticky_header_menu_hover_color'];
$theme_modern_sticky_header_menu_text_hover_color  = $header_style_options['theme_modern_sticky_header_menu_text_hover_color'];
$theme_modern_sticky_header_btn_color              = $header_style_options['theme_modern_sticky_header_btn_color'];
$theme_modern_sticky_header_btn_hover_color        = $header_style_options['theme_modern_sticky_header_btn_hover_color'];
$theme_modern_sticky_header_btn_text_color         = $header_style_options['theme_modern_sticky_header_btn_text_color'];
$theme_modern_sticky_header_btn_hover_text_color   = $header_style_options['theme_modern_sticky_header_btn_hover_text_color'];
$theme_modern_sticky_header_site_title_color       = $header_style_options['theme_modern_sticky_header_site_title_color'];
$theme_modern_sticky_header_site_title_hover_color = $header_style_options['theme_modern_sticky_header_site_title_hover_color'];

// Logo.
$theme_logo_text_color       = $header_style_options['theme_logo_text_color'];
$theme_logo_text_hover_color = $header_style_options['theme_logo_text_hover_color'];

return array(
	array(
		'elements' => '
		.rh_var2_nav_wrapper,
		.rh_var3_header
	',
		'property' => 'background',
		'value'    => $theme_header_menu_top_color
	),
	array(
		'elements' => '.rh_var2_header_meta_wrapper',
		'property' => 'background',
		'value'    => $theme_header_meta_bg_color
	),
	array(
		'elements' => '.rh_banner',
		'property' => 'background-color',
		'value'    => $theme_header_bg_color
	),
	array(
		'elements' => '
			.rh_logo .rh_logo__heading a,
			.rh_var_header .rh_logo__heading a
		',
		'property' => 'color',
		'value'    => $theme_logo_text_color
	),
	array(
		'elements' => '
			.rh_logo .rh_logo__heading a:hover,
			.rh_var_header .rh_logo__heading a:hover
		',
		'property' => 'color',
		'value'    => $theme_logo_text_hover_color
	),
	array(
		'elements' => '
			.rh_var_header ul.rh_menu__main li a, 
			.rh_var3_header.rh_var_header ul.rh_menu__main li a, 
			.rh_header_var_1 ul.rh_menu__main li a
		',
		'property' => 'color',
		'value'    => $theme_main_menu_text_color
	),
	array(
		'elements' => '
			.rh_var3_header.rh_var_header .rh_menu__main > li > a:after,
			.rh_var3_header.rh_var_header .rh_menu__main > current-menu-item > a:after
		',
		'property' => 'background',
		'value'    => $theme_main_menu_text_hover_color
	),
	array(
		'elements' => '
			.rh_header_var_1 ul.rh_menu__main li:hover > a,
			.rh_header_var_1 ul.rh_menu__main .current-menu-item > a,
			.rh_var3_header.rh_var_header ul.rh_menu__main li:hover > a, 
			.rh_var3_header.rh_var_header ul.rh_menu__main .current-menu-item a, 
			.rh_var_header .rh_menu__main li:hover > a,
			.rh_var_header .rh_menu__main .current-menu-item > a
		',
		'property' => 'color',
		'value'    => $theme_main_menu_text_hover_color
	),
	array(
		'elements' => '.rh_header--shadow',
		'property' => 'background',
		'value'    => 'linear-gradient(180deg,' . $gradient_staring . '0%, rgba(255, 255, 255, 0) 100%);',
	),
	array(
		'elements' => '
			.rh_header_var_1 ul.rh_menu__main > .current-menu-item > a,
			.rh_header_var_1 ul.rh_menu__main li:hover,
			.rh_header_var_1 ul.rh_menu__main li a:hover,
			.rh_header_var_1 ul.rh_menu__main li:hover > a 
		',
		'property' => 'background',
		'value'    => $inspiry_main_menu_hover_bg
	),
	array(
		'elements' => '
			ul.rh_menu__main ul.sub-menu,
		    .rh_header_var_1 ul.rh_menu__main ul.sub-menu,
		    .rh_header_var_1 ul.rh_menu__main ul.sub-menu ul.sub-menu,
		    .rh_var2_header .rh_menu__main .current-menu-item, 
		    .rh_var2_header .rh_menu__main > li:hover
		',
		'property' => 'border-top-color',
		'value'    => $inspiry_main_menu_hover_bg
	),
	array(
		'elements' => '
			.rh_var2_header .rh_menu__main .current-menu-item, 
		    .rh_var2_header .rh_menu__main > li:hover
		',
		'property' => 'border-color',
		'value'    => $inspiry_main_menu_hover_bg
	),
	array(
		'elements' => '
			ul.rh_menu__main ul.sub-menu, 
			ul.rh_menu__main ul.sub-menu ul.sub-menu,
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu,
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu ul.sub-menu
		',
		'property' => 'background',
		'value'    => $theme_menu_bg_color
	),
	array(
		'elements' => '
			ul.rh_menu__main ul.sub-menu,
			ul.rh_menu__main ul.sub-menu ul.sub-menu
		',
		'property' => 'border-top-color',
		'value'    => $inspiry_main_menu_hover_bg
	),
	array(
		'elements' => '
			ul.rh_menu__main ul.sub-menu li a, 
			ul.rh_menu__main ul.sub-menu ul.sub-menu a,
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu li a,
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu li ul.sub-menu li a,								
			.rh_var3_header ul.rh_menu__main ul.sub-menu li a,
			.rh_var3_header ul.rh_menu__main ul.sub-menu li ul.sub-menu li a,
			.rh_var_header .rh_menu__main li .current-menu-item > a,
			.rh_header_var_1 ul.rh_menu__main .pll-parent-menu-item .sub-menu li a span
		',
		'property' => 'color',
		'value'    => $theme_menu_text_color
	),
	array(
		'elements' => '
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu li.current-menu-item a,
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu li:hover > a,
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu ul.sub-menu li:hover > a,
			.rh_var2_header ul.rh_menu__main ul.sub-menu li:hover > a,
			.rh_var2_header ul.rh_menu__main ul.sub-menu ul.sub-menu li:hover > a,								
			.rh_var3_header ul.rh_menu__main ul.sub-menu li:hover > a,
			.rh_var3_header ul.rh_menu__main ul.sub-menu ul.sub-menu li:hover > a,
			.rh_var_header .rh_menu__main li .current-menu-parent, 
			.rh_var_header .rh_menu__main li .current-menu-item,
			.rh_var_header .rh_menu__main li .current-menu-item > a:hover,
			.rh_header_var_1 ul.rh_menu__main .pll-parent-menu-item .sub-menu li:hover a span
		',
		'property' => 'background',
		'value'    => $theme_menu_hover_bg_color
	),
	array(
		'elements' => '
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu li.current-menu-item a,
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu li:hover > a,
			.rh_header_var_1 ul.rh_menu__main ul.sub-menu ul.sub-menu li:hover > a,
			.rh_var2_header ul.rh_menu__main ul.sub-menu li:hover > a,
			.rh_var2_header ul.rh_menu__main ul.sub-menu ul.sub-menu li:hover > a,
			.rh_var3_header ul.rh_menu__main ul.sub-menu li:hover > a,
			.rh_var3_header ul.rh_menu__main ul.sub-menu ul.sub-menu li:hover > a,
			.rh_var_header .rh_menu__main li .current-menu-parent > a, 
			.rh_var_header .rh_menu__main li .current-menu-item > a:hover,
			.rh_header_var_1 ul.rh_menu__main .pll-parent-menu-item .sub-menu li:hover a span
		',
		'property' => 'color',
		'value'    => $theme_menu_hover_text_color
	),
	array(
		'elements' => '
			.rh_menu__user .rh_menu__user_phone .contact-number,
			.rh_var2_header_meta_container .rh_right_box .contact-number,
			.rh_var3_user_nav a.contact-number,
			.rh_var2_header_meta_container .rh_right_box .contact-email
		',
		'property' => 'color',
		'value'    => $theme_phone_text_color
	),
	array(
		'elements' => '
			.rh_var2_header_meta_container .rh_right_box .rh_menu__user_phone:hover a, 
			.rh_menu__user .rh_menu__user_phone:hover .contact-number,
			.rh_var2_header_meta_container .rh_right_box .rh_menu__user_email:hover a,
			.rh_var3_user_nav .rh_menu__user_phone:hover a.contact-number
		',
		'property' => 'color',
		'value'    => $theme_phone_text_color_hover
	),
	array(
		'elements' => '
			.rh_var2_social_icons:before,
			.rh_var2_social_icons a
		',
		'property' => 'color',
		'value'    => $theme_header_social_icon_color
	),
	array(
		'elements' => '.rh_var2_social_icons a:hover',
		'property' => 'color',
		'value'    => $theme_header_social_icon_color_hover
	),
	array(
		'elements' => '
			.rh_menu__user .rh_menu__user_phone svg,
			.rh_var3_user_nav svg,
			.rh_var2_header_meta_container .rh_right_box svg
		',
		'property' => 'fill',
		'value'    => $theme_phone_text_color
	),
	array(
		'elements' => '
			.rh_var2_header_meta_container .rh_right_box .rh_menu__user_phone:hover svg, 
			.rh_var2_header_meta_container .rh_right_box .rh_menu__user_email:hover svg,
			.rh_menu__user .rh_menu__user_phone:hover svg,
			.rh_var3_user_nav:hover svg
		',
		'property' => 'fill',
		'value'    => $theme_phone_text_color_hover
	),
	array(
		'elements' => '.rh_mod_sticky_header.sticky_header_custom',
		'property' => 'background',
		'value'    => $theme_modern_sticky_header_bg_color
	),
	array(
		'elements' => '.rh_mod_sticky_header.sticky_header_custom .menu-main-menu-container > ul > li > a',
		'property' => 'color',
		'value'    => $theme_modern_sticky_header_menu_color
	),
	array(
		'elements' => '
			.rh_mod_sticky_header.sticky_header_custom .menu-main-menu-container > ul > li:hover > a, 
			.rh_mod_sticky_header.sticky_header_custom .menu-main-menu-container > ul > li.current-menu-item > a,
			.rh_mod_sticky_header.sticky_header_custom .menu-main-menu-container > ul > li.active-menu-item > a
		',
		'property' => 'color',
		'value'    => $theme_modern_sticky_header_menu_text_hover_color
	),
	array(
		'elements' => '.rh_mod_sticky_header.sticky_header_custom .menu-main-menu-container li .sub-menu',
		'property' => 'border-top-color',
		'value'    => $theme_modern_sticky_header_menu_text_hover_color
	),
	array(
		'elements' => '
			.rh_mod_sticky_header.sticky_header_custom .rh_menu__user_submit a,
			.rh_mod_sticky_header.sticky_header_custom .rh_menu__user_submit a:hover
		',
		'property' => 'background-color',
		'value'    => $theme_modern_sticky_header_btn_color
	),
	array(
		'elements' => '.rh_mod_sticky_header.sticky_header_custom .rh_menu__user_submit a:before',
		'property' => 'background-color',
		'value'    => $theme_modern_sticky_header_btn_hover_color
	),
	array(
		'elements' => '.rh_mod_sticky_header.sticky_header_custom .rh_menu__user_submit a',
		'property' => 'color',
		'value'    => $theme_modern_sticky_header_btn_text_color
	),
	array(
		'elements' => '.rh_mod_sticky_header.sticky_header_custom .rh_menu__user_submit a:hover',
		'property' => 'color',
		'value'    => $theme_modern_sticky_header_btn_hover_text_color
	),
	array(
		'elements' => '.rh_mod_sticky_header.sticky_header_custom .rh_logo__heading a',
		'property' => 'color',
		'value'    => $theme_modern_sticky_header_site_title_color
	),
	array(
		'elements' => '.rh_mod_sticky_header.sticky_header_custom .rh_logo__heading a:hover',
		'property' => 'color',
		'value'    => $theme_modern_sticky_header_site_title_hover_color
	)
);