<?php
/**
 * Containing dynamic css header responsive style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

$header_styles_keys = array(
	'theme_responsive_header_bg_color',
	'theme_logo_responsive_text_color',
	'theme_responsive_phone_text_color',
	'theme_responsive_phone_text_color_hover',
	'theme_responsive_submit_button_bg',
	'theme_responsive_submit_button_bg_hover',
	'theme_responsive_submit_button_color',
	'theme_responsive_submit_button_color_hover',
	'theme_responsive_menu_icon_color',
	'theme_responsive_menu_bg_color',
	'theme_responsive_menu_text_color',
	'theme_responsive_menu_text_hover_color'
);

$header_style_options = realhomes_get_options( $header_styles_keys );

$theme_responsive_header_bg_color           = $header_style_options['theme_responsive_header_bg_color'];
$theme_logo_responsive_text_color           = $header_style_options['theme_logo_responsive_text_color'];
$theme_responsive_phone_text_color          = $header_style_options['theme_responsive_phone_text_color'];
$theme_responsive_phone_text_color_hover    = $header_style_options['theme_responsive_phone_text_color_hover'];
$theme_responsive_submit_button_bg          = $header_style_options['theme_responsive_submit_button_bg'];
$theme_responsive_submit_button_bg_hover    = $header_style_options['theme_responsive_submit_button_bg_hover'];
$theme_responsive_submit_button_color       = $header_style_options['theme_responsive_submit_button_color'];
$theme_responsive_submit_button_color_hover = $header_style_options['theme_responsive_submit_button_color_hover'];
$theme_responsive_menu_icon_color           = $header_style_options['theme_responsive_menu_icon_color'];
$theme_responsive_menu_bg_color             = $header_style_options['theme_responsive_menu_bg_color'];
$theme_responsive_menu_text_color           = $header_style_options['theme_responsive_menu_text_color'];
$theme_responsive_menu_text_hover_color     = $header_style_options['theme_responsive_menu_text_hover_color'];

return array(
	array(
		'elements' => '.rh_temp_header_responsive_view.rh_header',
		'property' => 'background',
		'value'    => $theme_responsive_header_bg_color,
	),
	array(
		'elements' => '.rh_temp_header_responsive_view .rh_logo__heading a',
		'property' => 'color',
		'value'    => $theme_logo_responsive_text_color,
	),
	array(
		'elements' => '.rh_temp_header_responsive_view .rh_menu__user_phone .contact-number',
		'property' => 'color',
		'value'    => $theme_responsive_phone_text_color,
	),
	array(
		'elements' => '.rh_temp_header_responsive_view .rh_menu__user_phone svg',
		'property' => 'fill',
		'value'    => $theme_responsive_phone_text_color,
	),
	array(
		'elements' => '.rh_temp_header_responsive_view .rh_menu__user_phone:hover .contact-number',
		'property' => 'color',
		'value'    => $theme_responsive_phone_text_color_hover,
	),
	array(
		'elements' => '.rh_temp_header_responsive_view .rh_menu__user_phone:hover svg',
		'property' => 'fill',
		'value'    => $theme_responsive_phone_text_color_hover,
	),
	array(
		'elements' => '
			.rh_temp_header_responsive_view .rh_menu__user_submit a,
			.rh_temp_header_responsive_view .rh_menu__user_submit a:hover
		',
		'property' => 'background',
		'value'    => $theme_responsive_submit_button_bg,
	),
	array(
		'elements' => '.rh_temp_header_responsive_view .rh_menu__user_submit a:before',
		'property' => 'background',
		'value'    => $theme_responsive_submit_button_bg_hover,
	),
	array(
		'elements' => '.rh_temp_header_responsive_view .rh_menu__user_submit a',
		'property' => 'color',
		'value'    => $theme_responsive_submit_button_color,
	),
	array(
		'elements' => '.rh_temp_header_responsive_view .rh_menu__user_submit a:hover',
		'property' => 'color',
		'value'    => $theme_responsive_submit_button_color_hover,
	),
	array(
		'elements' => '.hamburger-inner, .hamburger-inner::before, .hamburger-inner::after',
		'property' => 'background-color',
		'value'    => $theme_responsive_menu_icon_color,
	),
	array(
		'elements' => '.rh_menu__responsive',
		'property' => 'background-color',
		'value'    => $theme_responsive_menu_bg_color,
	),
	array(
		'elements' => '.rh_menu__responsive ul.sub-menu',
		'property' => 'background-color',
		'value'    => inspiry_hex_darken( $theme_responsive_menu_bg_color, 4 ),
	),
	array(
		'elements' => '.rh_menu__responsive ul.sub-menu ul.sub-menu',
		'property' => 'background-color',
		'value'    => inspiry_hex_darken( $theme_responsive_menu_bg_color, 6 ),
	),
	array(
		'elements' => '
			.rh_menu__responsive li a,
			.rh_menu__responsive .rh_menu__indicator
		',
		'property' => 'color',
		'value'    => $theme_responsive_menu_text_color,
	),
	array(
		'elements' => '.rh_menu__responsive li a:hover',
		'property' => 'color',
		'value'    => $theme_responsive_menu_text_hover_color,
	)
);