<?php
/**
 * Containing dynamic css core theme style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage modern
 */

$core_styles_array = array();

$core_styles_keys = array(
	'theme_core_mod_color_orange',
	'theme_core_mod_color_green',
	'theme_core_mod_color_green_dark',
	array( 'realhomes_selection_bg_color', '#1ea69a' )
);

$core_style_options = realhomes_get_options( $core_styles_keys );

$body_bg               = get_background_color();
$core_orange_color     = $core_style_options['theme_core_mod_color_orange'];
$core_green_color      = $core_style_options['theme_core_mod_color_green'];
$core_green_dark_color = $core_style_options['theme_core_mod_color_green_dark'];
$selection_bg_color    = $core_style_options['realhomes_selection_bg_color'];

if ( ! empty( $core_orange_color ) ) {
	$core_styles_array[] = array(
		'elements' => '.cls-1',
		'property' => 'fill',
		'value'    => $core_orange_color . '!important',
	);
}

$core_styles_array[] = array(
	'elements' => '
		.inspiry_mod_header_varition_one ul.rh_menu__main li a:hover,
		.inspiry_mod_header_varition_one ul.rh_menu__main > .current-menu-item > a,
		.inspiry_mod_header_varition_one ul.rh_menu__main > .current-menu-ancestor > a,
		.inspiry_mod_header_varition_one ul.rh_menu__main li:hover, 
		.rh_menu--hover,
		.rh_section__featured .rh_flexslider__nav a:hover,
		.dsidx-widget-guided-search form input[type=submit]:hover,
		.dsidx-widget-quick-search form input[type=submit]:hover,
		#ihf-main-container .btn-primary.active,
		.rh_prop_search__buttons_smart .rh_prop_search__advance a,
		.rh_prop_search__buttons_smart .rh_prop_search__searchBtn button,
		.rh_header_var_1 ul.rh_menu__main li:hover,
		.rh_header_var_1 ul.rh_menu__main > .current-menu-item > a,
		.rh_header_var_1 ul.rh_menu__main > .current-menu-ancestor > a,
		.rh_header_var_1 ul.rh_menu__main li a:hover,
		.rh_btn--secondary, 
		.mc4wp-form-fields input[type="submit"],
		.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button,
		.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__advance a,
		.rh_form__item .inspiry-details-wrapper .inspiry-detail .add-detail,
		.brands-owl-carousel .owl-nav button.owl-prev:hover:not(.disabled), 
		.brands-owl-carousel .owl-nav button.owl-next:hover:not(.disabled),
		.rh_agent_options label .control__indicator:after,
		.inspiry_bs_orange div.dropdown-menu,
		.rh_prop_search__form_smart .inspiry_select_picker_trigger.open button.dropdown-toggle,
		.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu,
		.widget.RVR_Booking_Widget h4.title,
		.rvr_phone_icon,
		.rh_cfos .cfos_phone_icon,
		.woocommerce span.onsale, .woocommerce .widget_price_filter .ui-slider .ui-slider-handle, .woocommerce .widget_price_filter .price_slider_wrapper .ui-widget-content
	',
	'property' => 'background',
	'value'    => $core_orange_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_cfos .cfos_phone_icon:after,
								.rvr_phone_icon:after',
	'property' => 'border-left-color',
	'value'    => $core_orange_color,
);

$core_styles_array[] = array(
	'elements' => '
		.rtl .rh_cfos .cfos_phone_icon:before,
		.rh_prop_search__form_smart .rh_form_smart_top_fields .inspiry_select_picker_trigger.open button.dropdown-toggle
	',
	'property' => 'border-right-color',
	'value'    => $core_orange_color,
);

$core_styles_array[] = array(
	'elements' => '
		.rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link .rh_agent_form .rh_agent_form__row,
		.rh_agent_form .rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link .rh_agent_form__row,
		.rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link p,
		.rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link span,
		.rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link i,
		.qe-faqs-filters-container li a:hover,
		#dsidx-top-search span.dsidx-search-bar-openclose:hover,
		#dsidx.dsidx-results .dsidx-paging-control a:hover,
		.dsidx-results-widget .dsidx-expanded .featured-listing>h4 a:hover,
		.commentlist article .comment-detail-wrap .comment-reply-link:hover,
		.rh_modal .rh_modal__wrap a:hover,
		.agent-content-wrapper .description a, 
		.agent-content-wrapper .rh_agent_card__link,
		.rh_prop_search__wrap_smart .open_more_features,
		.inspiry_mod_search_form_smart .rh_prop_search__wrap_smart .open_more_features,
		.rh_section__news_wrap .categories a:hover,
		.rh_agent .rh_agent__details .rh_agent__phone a:hover,
		.rvr_optional_services_status li.rh_property__feature .rvr_not_available i,
		.rvr_fa_icon
	',
	'property' => 'color',
	'value'    => $core_orange_color,
);

$core_styles_array[] = array(
	'elements' => '
		.rh_prop_search__buttons_smart .rh_prop_search__searchBtn button:hover,
		.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__searchBtn button:hover,
		.rh_form__item .inspiry-details-wrapper .inspiry-detail .add-detail:hover
	',
	'property' => 'background',
	'value'    => inspiry_hex_darken( $core_orange_color, 4 )
);

$core_styles_array[] = array(
	'elements' => '
		.inspiry_bs_orange div.dropdown-menu li.selected a,
		.inspiry_bs_orange div.dropdown-menu li:hover a,
		.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu li.selected a,
		.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu li:hover a,
		.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
		.rh_prop_search__form_smart .inspiry_select_picker_trigger .bs-actionsbox .btn-block .bs-select-all:hover,
		.rh_prop_search__form_smart .inspiry_select_picker_trigger .bs-actionsbox .btn-block .bs-deselect-all:hover
	',
	'property' => 'background',
	'value'    => inspiry_hex_darken( $core_orange_color, 8 ),
);

$core_styles_array[] = array(
	'elements' => '.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb',
	'property' => 'outline-color',
	'value'    => inspiry_hex_darken( $core_orange_color, 8 ),
);

$core_styles_array[] = array(
	'elements' => '.rh_prop_search__form_smart .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-track',
	'property' => 'box-shadow',
	'value'    => ' inset 0 0 6px ' . inspiry_hex_darken( $core_orange_color, 8 ),
);

$core_styles_array[] = array(
	'elements' => '
		.rh_cta__wrap .rh_cta__btns .rh_btn--secondary,
		.availability-calendar table td.unavailable,
		div.daterangepicker .calendar-table td.reserved,
		.rh_property__ava_calendar_wrap .calendar-guide ul li.reserved-days::before
	',
	'property' => 'background',
	'value'    => inspiry_hex_to_rgba( $core_orange_color, 1 ),
);

$core_styles_array[] = array(
	'elements' => '
		.rh_cta__wrap .rh_cta__btns .rh_btn--secondary:hover, 
		.rh_btn--secondary:hover, .mc4wp-form-fields input:hover[type="submit"],
		.inspiry_mod_search_form_smart .rh_prop_search__buttons_smart .rh_prop_search__advance a
	',
	'property' => 'background',
	'value'    => inspiry_hex_to_rgba( $core_orange_color, .8 ),
);

$core_styles_array[] = array(
	'elements' => '
		.rh_modal .rh_modal__wrap .rh_modal__dashboard .rh_modal__dash_link:hover svg,
		.rh_property__features_wrap .rh_property__feature .rh_done_icon svg,
		.rh_prop_card .rh_prop_card__thumbnail .rh_prop_card__btns a:hover svg path,
		.rh_list_card__wrap .rh_list_card__map_thumbnail .rh_list_card__btns a:hover svg path,
		.rh_property__print .rh_single_compare_button .highlight svg path,
		.rh_double_check,
		.rh_fav_icon_box a:hover svg path,
		.highlight svg path
	',
	'property' => 'fill',
	'value'    => $core_orange_color,
);

$core_styles_array[] = array(
	'elements' => '
		ul.rh_menu__main ul.sub-menu,
		.rh_header_var_1 ul.rh_menu__main ul.sub-menu,
		.rh_header_var_1 ul.rh_menu__main ul.sub-menu ul.sub-menu
	',
	'property' => 'border-top-color
	',
	'value'    => $core_orange_color,
);

$core_styles_array[] = array(
	'elements' => '
		.qe-testimonial-wrapper .qe-testimonial-img a:hover .avatar,
		.commentlist article>a:hover img,
		.rh_var_header .rh_menu__main .current-menu-ancestor,
		.rh_var_header .rh_menu__main .current-menu-item,
		.rh_var_header .rh_menu__main > li:hover,
		.rh_prop_search__form_smart .inspiry_select_picker_trigger.open button.dropdown-toggle
	',
	'property' => 'border-color',
	'value'    => $core_orange_color,
);

$core_styles_array[] = array(
	'elements' => '::selection',
	'property' => 'background-color',
	'value'    => $selection_bg_color,
);

$core_styles_array[] = array(
	'elements' => '::-moz-selection',
	'property' => 'background-color',
	'value'    => $selection_bg_color,
);
$core_styles_array[] = array(
	'elements' => '
		.rh_slide__desc .rh_slide_prop_price span,
		.rh_slide__desc h3 .title:hover,
		.rh_section--props_padding .rh_section__head .rh_section__subtitle,
		.rh_section .rh_section__head .rh_section__subtitle,
		.rh_prop_card .rh_prop_card__details h3 a:hover,
		.rh_list_card__wrap .rh_list_card__map_wrap h3 a:hover,
		.rh_list_card__wrap .rh_list_card__details_wrap h3 a:hover,
		.rh_prop_card .rh_prop_card__details .rh_prop_card__priceLabel .rh_prop_card__price,
		.rh_list_card__wrap .rh_list_card__map_details .rh_list_card__priceLabel .rh_list_card__price .price,
		.rh_list_card__wrap .rh_list_card__priceLabel .rh_list_card__price .price,
		.rh_prop_card .rh_prop_card__thumbnail .rh_overlay__contents a:hover,
		.rh_agent .rh_agent__details h3 a:hover,
		.rh_agent .rh_agent__details .rh_agent__phone a,
		.rh_agent .rh_agent__details .rh_agent__email:hover,
		.rh_agent .rh_agent__details .rh_agent__listed .figure,
		.rh_list_card__wrap .rh_list_card__thumbnail .rh_overlay__contents a:hover,
		.property-template-default .rh_page__property_price .price,
		.rh_page__property .rh_page__property_price .price,
		.rh_property_agent .rh_property_agent__agent_info .email .value,
		.rh_property__id .id,
		.rh_property__heading,
		.rvr_price_details_wrap .rvr_price_details ul li.bulk-pricing-heading,
		.rh_agent_card__wrap .rh_agent_card__head .rh_agent_card__listings .count,
		.rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link:hover .rh_agent_form .rh_agent_form__row,
		.rh_agent_form .rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link:hover .rh_agent_form__row,
		.rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link:hover p,
		.rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link:hover span,
		.rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__link:hover i,
		.rh_agent_card__wrap .rh_agent_card__head .rh_agent_card__name .name a:hover,
		.rh_agent_card__wrap .rh_agent_card__details .rh_agent_card__contact .rh_agent_card__contact_wrap .contact a:hover,
		.rh_agent_profile__wrap .rh_agent_profile__head .rh_agent_profile__details .detail a:hover,
		.rh_agent_profile__wrap .rh_agent_profile__head .rh_agent_profile__dp .listed_properties .number,
		.agent-content-wrapper .listed_properties .number,
		.rh_page__head .rh_page__title .sub,
		.rh_gallery__wrap .rh_gallery__item .item-title a:hover,
		.qe-testimonial-wrapper .qe-testimonial-byline a,
		.qe-faqs-filters-container li a,
		ol.dsidx-results li.dsidx-prop-summary .dsidx-prop-features>div:before,
		#dsidx-top-search span.dsidx-search-bar-openclose,
		#dsidx.dsidx-results .dsidx-paging-control a,
		.dsidx-results:not(.dsidx-results-grid) #dsidx-listings .dsidx-listing .dsidx-data .dsidx-primary-data .dsidx-price,
		.dsidx-results:not(.dsidx-results-grid) #dsidx-listings .dsidx-listing .dsidx-data .dsidx-secondary-data>div:before,
		.dsidx-results-widget .dsidx-expanded .featured-listing ul li:before,
		#ihf-main-container a:focus,
		#ihf-main-container a:hover,
		#ihf-main-container h4.ihf-price,
		#ihf-main-container a:hover .ihf-grid-result-address,
		#ihf-main-container a:focus .ihf-grid-result-address,
		.commentlist article .comment-detail-wrap .comment-reply-link,
		.page-breadcrumbs-modern li a,
		.page-breadcrumbs-modern li i,
		.agent-content-wrapper .description a:hover,
		.agent-content-wrapper .rh_agent_card__link:hover,
		.property-thumbnail .property-price p,
		.property-thumbnail .property-title a:hover,
		.rh_property__agent_head .description p a:hover,
		.rh_property__agent_head .contacts-list .contact.email a:hover,
		.rh_section__news_wrap .categories a,
		.rh_section__news_wrap h3 a:hover,
		.rh_compare__slide_img .rh_compare_view_title:hover,
		div.rh_login_modal_wrapper .rh_login_tabs li.rh_active,
		div.rh_login_modal_wrapper .rh_login_tabs li:hover,
		.rh_list_card__wrap .rh_list_card__map_thumbnail .rh_overlay__contents a:hover,
		body .leaflet-popup-content p,
		body .leaflet-popup-content .osm-popup-title a:hover,
		body .rh_compare__slide_img .rh_compare_view_title:hover,
		.rh_my-property .rh_my-property__publish .publish h5,
		.rh_property__yelp_wrap .yelp-places-group-title i,
		.infoBox .map-info-window p,
		.rvr_request_cta_number_wrapper .rvr-phone-number a,
		.widget.RVR_Owner_Widget .rvr_widget_owner_label,
		.infoBox .map-info-window a:hover,
		.woocommerce ul.products li.product .price, .woocommerce div.product p.price, .woocommerce div.product .rh_agent_form .price.rh_agent_form__row, .rh_agent_form .woocommerce div.product .price.rh_agent_form__row, .woocommerce div.product span.price, .woocommerce ul.cart_list li .amount, .woocommerce ul.product_list_widget li .amount,
		.rh_property__meta_wrap .rh_property__meta i,
		.commentlist article .comment-detail-wrap .url,
		h3.rh_heading_stylish a:hover,
		.rh_theme_card__priceLabel_sty .rh_theme_card__price_sty,
		.floor-plans-accordions .floor-plan-title .floor-plan-meta .floor-price-value,
		.rvr_guests_accommodation_wrap .rvr_guests_accommodation ul li i.fas
    ',
	'property' => 'color',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '
		.rh_btn--primary, 
		.post-password-form input[type="submit"],
		.widget .searchform input[type="submit"],
		.comment-form .form-submit .submit,
		.rh_memberships__selection #ims-stripe-payment-btn .stripe-button-el,
		.rh_memberships__selection #ims-free-button,
		.rh_contact__form .wpcf7-form input[type="submit"],
		.widget_mortgage-calculator .mc-wrapper p input[type="submit"],
		.rh_memberships__selection .ims-receipt-button #ims-receipt,
		.rh_contact__form .rh_contact__input input[type="submit"],
		.rh_form__item input[type="submit"], .rh_pagination__pages-nav a,
		.rh_modal .rh_modal__wrap button,
		.rh_section__testimonial .diagonal-mod-background,
		.rh_section__testimonial.flat-border,
		.rh_blog__post .entry-header,
		.rh_prop_search__form .rh_prop_search__fields .rh_prop_search__active,
		.dsidx-widget-guided-search form input[type=submit],
		.dsidx-widget-quick-search form input[type=submit],
		ol.dsidx-results li.dsidx-prop-summary .dsidx-prop-title,
		.rh_blog__post .entry-header,
		.dsidx-results:not(.dsidx-results-grid) #dsidx-listings .dsidx-listing .dsidx-media .dsidx-photo .dsidx-photo-count,
		#dsidx-top-search #dsidx-search-bar .dsidx-search-controls .button button,
		.dsidx-results-grid #dsidx-listings .dsidx-listing .dsidx-data .dsidx-primary-data .dsidx-price,
		.dsidx-results-grid #dsidx-listings .dsidx-listing .dsidx-media .dsidx-photo .dsidx-photo-count,
		#dsidx .dsidx-large-button,
		#dsidx .dsidx-small-button,
		body.dsidx .dsidx-large-button,
		body.dsidx .dsidx-small-button,
		#dsidx-rentzestimate-notice,
		#dsidx-zestimate-notice,
		#dsidx.dsidx-details .dsidx-headerbar-green,
		#ihf-main-container .title-bar-1,
		#ihf-main-container .btn-primary,
		#ihf-main-container .dropdown-menu>.active>a,
		#ihf-main-container .dropdown-menu>li>a:hover,
		#ihf-main-container .pagination li:first-child>a,
		#ihf-main-container .pagination li:first-child>span,
		#ihf-main-container .pagination li:last-child>a,
		#ihf-main-container .pagination li:last-child>span,
		#ihf-main-container .ihf-map-search-refine-link,
		#ihf-main-container .btn-default,
		.rh_sidebar .widget_ihomefinderpropertiesgallery>a,
		#ihf-main-container .ihf-social-share .ihf-share-btn-email,
		#ihf-main-container .ihf-social-share .ihf-share-btn-facebook,
		#ihf-main-container .ihf-social-share .ihf-share-btn-more,
		#ihf-main-container .ihf-social-share .ihf-share-btn-print,
		button,
		#ihf-main-container .modal-footer .btn,
		.ihf-map-icon,
		.rh_var2_header_meta_wrapper,
		.rh_var3_header,
		.open_more_features,
		#home-properties-section .pagination a.current,
		#home-properties-section .pagination a:hover,
		.inspiry-floor-plans-group-wrapper .inspiry-btn-group .real-btn,
		body .rh_fixed_side_bar_compare .rh_compare__submit,
		.agent-custom-contact-form .wpcf7 input[type="submit"],
		.rh_mod_sfoi_wrapper .rh_prop_search__select.rh_prop_search__active,
		body .leaflet-popup-tip,
		body .marker-cluster-small div,
		.rh_prop_search__form .rh_prop_search__fields .inspiry_bs_is_open,
		.rh_prop_search__form .rh_prop_search__fields .inspiry_bs_is_open .inspiry_select_picker_trigger button.dropdown-toggle,
		.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu,
		#ui-datepicker-div .ui-datepicker-header,
		#ui-datepicker-div .ui-datepicker-calendar tbody tr td.ui-datepicker-today a, 
		#ui-datepicker-div.schedule-calendar-wrapper .ui-datepicker-calendar tbody tr td a.ui-state-highlight, 
		#ui-datepicker-div.schedule-calendar-wrapper .ui-datepicker-calendar tbody tr td a.ui-state-highlight:hover, 
		#ui-datepicker-div .ui-datepicker-calendar tbody tr td.ui-datepicker-current-day,
		form.rh_sfoi_advance_search_form .inspiry_bs_is_open,
		form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu,
		.inspiry_bs_green div.dropdown-menu,
		.widget.RVR_Booking_Widget .rvr-booking-form-wrap .rvr-booking-form .submission-area input[type="submit"],
		.availability-calendar .paging,
		.cluster div,
		.ere_latest_properties_ajax .pagination a.current,
		.ere_latest_properties_ajax .pagination a:hover,
		.woocommerce #respond input#submit:hover,
		.woocommerce-page-wrapper .woocommerce a.button:hover,
		.woocommerce a.button:hover,
		.woocommerce button.button:hover,
		.woocommerce input.button:hover,
		.woocommerce #respond input#submit.alt:hover,
		.woocommerce a.button.alt:hover,
		.woocommerce button.button.alt:hover,
		.woocommerce input.button.alt:hover,
		.woocommerce .widget_price_filter .ui-slider .ui-slider-range,
		.select2-container--open .select2-dropdown--below, .select2-container--open .select2-dropdown--above,
		div.daterangepicker td.active, div.daterangepicker td.active:hover,
		.availability-calendar table td.today,
		.rh_property__ava_calendar_wrap .calendar-guide ul li.today::before
	',
	'property' => 'background',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item input[type=range]::-webkit-slider-thumb',
	'property' => 'background',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item input[type=range]::-moz-range-thumb ',
	'property' => 'background',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .rh_mc_field .rh_form__item input[type=range]::-ms-thumb',
	'property' => 'background',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost_graph_circle .mc_graph_svg .mc_graph_interest',
	'property' => 'stroke',
	'value'    => $core_orange_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost_graph_circle .mc_graph_svg .mc_graph_tax',
	'property' => 'stroke',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost_graph_circle .mc_graph_svg .mc_graph_hoa',
	'property' => 'stroke',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .3 ),
);

$core_styles_array[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost li.mc_cost_interest::before',
	'property' => 'background-color',
	'value'    => $core_orange_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost li.mc_cost_tax::before',
	'property' => 'background-color',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_property__mc_wrap .rh_property__mc .mc_cost li.mc_cost_hoa::before',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .3 ),
);

$core_styles_array[] = array(
	'elements' => '
		#ihf-main-container .btn-primary:active,
		#ihf-main-container .btn-primary:focus,
		#ihf-main-container .btn-primary:hover,
		#ihf-main-container .pagination li:first-child>a:hover,
		#ihf-main-container .pagination li:first-child>span:hover,
		#ihf-main-container .pagination li:last-child>a:hover,
		#ihf-main-container .pagination li:last-child>span:hover,
		#ihf-main-container .ihf-map-search-refine-link,
		#ihf-main-container .btn-default:active,
		#ihf-main-container .btn-default:focus,
		#ihf-main-container .btn-default:hover,
		.rh_sidebar .widget_ihomefinderpropertiesgallery>a:hover,
		#ihf-main-container .ihf-social-share .ihf-share-btn-email:hover,
		#ihf-main-container .ihf-social-share .ihf-share-btn-facebook:hover,
		#ihf-main-container .ihf-social-share .ihf-share-btn-more:hover,
		#ihf-main-container .ihf-social-share .ihf-share-btn-print:hover,
		#ihf-main-container .modal-footer .btn:active,
		#ihf-main-container .modal-footer .btn:focus,
		#ihf-main-container .modal-footer .btn:hover,
		.inspiry-floor-plans-group-wrapper .inspiry-btn-group .real-btn:hover,
		.agent-custom-contact-form .wpcf7 input[type="submit"]:hover,
		.widget.RVR_Booking_Widget .rvr-booking-form-wrap .rvr-booking-form .submission-area input[type="submit"]:hover,
		.rh_mode_sfoi_search_btn button:hover
	',
	'property' => 'background',
	'value'    => inspiry_hex_darken( $core_green_color, 4 ),
);

$core_styles_array[] = array(
	'elements' => '
		.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu li.selected,
		.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu li:hover,
		.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
		form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu li.selected,
		form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu li:hover,
		form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
		.inspiry_bs_green div.dropdown-menu li.selected a,
		form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu .actions-btn:hover,
		.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu .actions-btn:hover,
		.inspiry_bs_green div.dropdown-menu ::-webkit-scrollbar-thumb,
		.inspiry_bs_green div.dropdown-menu li:hover a
	',
	'property' => 'background',
	'value'    => inspiry_hex_darken( $core_green_color, 8 ),
);

$core_styles_array[] = array(
	'elements' => '
		.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
		form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-thumb,
		.inspiry_bs_green div.dropdown-menu ::-webkit-scrollbar-thumb
	',
	'property' => 'outline-color',
	'value'    => inspiry_hex_darken( $core_green_color, 8 ),
);

$core_styles_array[] = array(
	'elements' => '
		.rh_prop_search__form .rh_prop_search__fields .inspiry_select_picker_field .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-track,
		form.rh_sfoi_advance_search_form .inspiry_select_picker_trigger div.dropdown-menu ::-webkit-scrollbar-track,
		.inspiry_bs_green div.dropdown-menu ::-webkit-scrollbar-track
	',
	'property' => 'box-shadow',
	'value'    => ' inset 0 0 6px ' . inspiry_hex_darken( $core_green_color, 8 ),
);

$core_styles_array[] = array(
	'elements' => '.rh_overlay',
	'property' => 'background',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .7 ),
);

$core_styles_array[] = array(
	'elements' => '#dsidx-zestimate,#dsidx-rentzestimate',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .1 ),
);

$core_styles_array[] = array(
	'elements' => '.rh_my-property .rh_my-property__publish .publish ',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .3 ),
);

$core_styles_array[] = array(
	'elements' => '.rh_cta--contact .rh_cta .rh_cta__overlay',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .8 ),
);

$core_styles_array[] = array(
	'elements' => '.rh_gallery__wrap .rh_gallery__item .media_container',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .9 ),
);

$core_styles_array[] = array(
	'elements' => 'blockquote,
				               .qe-faq-toggle .qe-toggle-title',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .1 ),
);

$core_styles_array[] = array(
	'elements' => '
		.qe-faq-toggle .qe-toggle-title:hover,
		.qe-faq-toggle.active .qe-toggle-title,
		div.daterangepicker td.in-range:not(.active,.ends),
		.availability-calendar table td.available:not(.past-date,.today),
		.rh_property__ava_calendar_wrap .calendar-guide ul li.available-days::before
	',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .2 ),
);

$core_styles_array[] = array(
	'elements' => '.qe-faq-toggle .qe-toggle-content',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .05 ),
);

$core_styles_array[] = array(
	'elements' => 'body .marker-cluster-small, .cluster',
	'property' => 'background-color',
	'value'    => inspiry_hex_to_rgba( $core_green_color, .5 ),
);

$core_styles_array[] = array(
	'elements' => '
		.rh_page__gallery_filters a.active,
		.rh_page__gallery_filters a:hover,
		.rh_page__head .rh_page__nav .active,
		.rh_page__head .rh_page__nav .rh_page__nav_item:hover,
		div.rh_login_modal_wrapper .rh_login_tabs li.rh_active,
		div.rh_login_modal_wrapper .rh_login_tabs li:hover,
		body .leaflet-popup-content-wrapper,
		.infoBox .map-info-window
	',
	'property' => 'border-bottom-color',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '
		.ihf-map-icon:after, .infoBox .map-info-window .arrow-down,
		.rh_latest_properties_2 .rh_tags_wrapper .rh_featured:before
	',
	'property' => 'border-top-color',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '
		blockquote,
		.qe-testimonial-wrapper .qe-testimonial-img a .avatar,
		#dsidx-rentzestimate, #dsidx-zestimate,
		#dsidx.dsidx-details .dsidx-headerbar-green,
		#dsidx.dsidx-details .dsidx-contact-form,
		.commentlist article>a img,
		.woocommerce #respond input#submit:hover,
		.woocommerce-page-wrapper .woocommerce a.button:hover,
		.woocommerce a.button:hover,
		.woocommerce button.button:hover,
		.woocommerce input.button:hover,
		.woocommerce #respond input#submit.alt:hover,
		.woocommerce a.button.alt:hover,
		.woocommerce button.button.alt:hover,
		.woocommerce input.button.alt:hover
	',
	'property' => 'border-color',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '
		blockquote,
		#dsidx-rentzestimate-triangle, #dsidx-zestimate-triangle,
		.rh_latest_properties_2 .rh_tags_wrapper .rh_featured:before
	',
	'property' => 'border-left-color',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '.rh_latest_properties_2 .rh_tags_wrapper .rh_featured:before',
	'property' => 'border-right-color',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '
		.rh_slide__prop_meta .rh_svg,
		.rh_svg,
		.rh_banner .rh_view_type .active path,
		.rh_banner .rh_view_type a:hover path,
		.rh_view_type a.active svg path,
		.rh_view_type a:hover svg path,							  
		div.rh_modal_login_loader svg path
	',
	'property' => 'fill',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '
		.rh_agent_card__wrap .rh_agent_card__head .rh_agent_card__name .name .rh_agent_verification__icon,
		.rh_view_type a svg path
	',
	'property' => 'background',
	'value'    => $core_green_color,
);

$core_styles_array[] = array(
	'elements' => '
		.rh_btn--primary:hover, 
		.post-password-form input[type="submit"]:hover,
		.widget .searchform input[type="submit"]:hover,
		.comment-form .form-submit .submit:hover,
		.rh_memberships__selection #ims-stripe-payment-btn .stripe-button-el:hover,
		.rh_memberships__selection #ims-free-button:hover,
		.rh_contact__form .wpcf7-form input[type="submit"]:hover,
		.widget_mortgage-calculator .mc-wrapper p input[type="submit"]:hover,
		.rh_memberships__selection .ims-receipt-button #ims-receipt:hover,
		.rh_contact__form .rh_contact__input input[type="submit"]:hover,
		.rh_form__item input[type="submit"]:hover, .rh_pagination__pages-nav a:hover,
		.rh_modal .rh_modal__wrap button:hover,
		#dsidx .dsidx-large-button:hover,
		#dsidx .dsidx-small-button:hover,
		body.dsidx .dsidx-large-button:hover,
		body.dsidx .dsidx-small-button:hover,
		.open_more_features:hover,
		#rh_save_search button:hover,
		body .rh_fixed_side_bar_compare .rh_compare__submit:hover,
		.select2-container--default .select2-results__option[aria-selected=true], 
		.select2-container--default .select2-results__option[data-selected=true],
		div.rh_login_modal_wrapper button:not(.dropdown-toggle):hover
	',
	'property' => 'background',
	'value'    => $core_green_dark_color,
);

$core_styles_array[] = array(
	'elements' => '.page-breadcrumbs-modern li a:hover',
	'property' => 'color',
	'value'    => $core_green_dark_color,
);

$core_styles_array[] = array(
	'elements' => '
		.rh_section__testimonial .quotes-marks svg,
		.rh_view_type a svg path
	',
	'property' => 'fill',
	'value'    => $core_green_dark_color,
);


if ( ! empty( $core_green_color ) ) {
	$core_styles_array[] = array(
		'elements' => '
			#ihf-main-container .ihf-select-options .ihf-select-available-option>span.ihf-selected,
			.ihf-eureka .ihf-select-options .ihf-select-available-option>span.ihf-selected,
			#ihf-main-container .btn-primary,
			#ihf-main-container .btn.btn-default,
			#ihf-main-container .ihf-btn.ihf-btn-primary,
			.ihf-eureka .btn-primary,
			.ihf-eureka .btn.btn-default,
			.ihf-eureka .ihf-btn.ihf-btn-primary
		',
		'property' => 'background-color',
		'value'    => $core_green_color . ' !important',
	);
	$core_styles_array[] = array(
		'elements' => '
			#ihf-main-container .btn-primary,
			#ihf-main-container .btn.btn-default,
			#ihf-main-container .ihf-btn.ihf-btn-primary,
			.ihf-eureka .btn-primary,
			.ihf-eureka .btn.btn-default,
			.ihf-eureka .ihf-btn.ihf-btn-primary
		',
		'property' => 'border-color',
		'value'    => $core_green_color . ' !important',
	);
	$core_styles_array[] = array(
		'elements' => '#ihf-main-container .ihf-detail-tab-content #ihf-detail-features-tab .title-bar-1',
		'property' => 'background-color',
		'value'    => $core_green_color . ' !important',
	);
	$core_styles_array[] = array(
		'elements' => '
			#ihf-main-container .btn-primary:active,
			#ihf-main-container .btn-primary:focus,
			#ihf-main-container .btn-primary:hover,
			#ihf-main-container .btn.btn-default:active,
			#ihf-main-container .btn.btn-default:focus,
			#ihf-main-container .btn.btn-default:hover,
			#ihf-main-container .ihf-btn.ihf-btn-primary:active,
			#ihf-main-container .ihf-btn.ihf-btn-primary:focus,
			#ihf-main-container .ihf-btn.ihf-btn-primary:hover,
			.ihf-eureka .btn-primary:active,
			.ihf-eureka .btn-primary:focus,
			.ihf-eureka .btn-primary:hover,
			.ihf-eureka .btn.btn-default:active,
			.ihf-eureka .btn.btn-default:focus,
			.ihf-eureka .btn.btn-default:hover,
			.ihf-eureka .ihf-btn.ihf-btn-primary:active,
			.ihf-eureka .ihf-btn.ihf-btn-primary:focus,
			.ihf-eureka .ihf-btn.ihf-btn-primary:hover
		',
		'property' => 'background-color',
		'value'    => $core_green_dark_color . ' !important',
	);
	$core_styles_array[] = array(
		'elements' => '
			#ihf-main-container .btn-primary:active,
			#ihf-main-container .btn-primary:focus,
			#ihf-main-container .btn-primary:hover,
			#ihf-main-container .btn.btn-default:active,
			#ihf-main-container .btn.btn-default:focus,
			#ihf-main-container .btn.btn-default:hover,
			#ihf-main-container .ihf-btn.ihf-btn-primary:active,
			#ihf-main-container .ihf-btn.ihf-btn-primary:focus,
			#ihf-main-container .ihf-btn.ihf-btn-primary:hover,
			.ihf-eureka .btn-primary:active,
			.ihf-eureka .btn-primary:focus,
			.ihf-eureka .btn-primary:hover,
			.ihf-eureka .btn.btn-default:active,
			.ihf-eureka .btn.btn-default:focus,
			.ihf-eureka .btn.btn-default:hover,
			.ihf-eureka .ihf-btn.ihf-btn-primary:active,
			.ihf-eureka .ihf-btn.ihf-btn-primary:focus,
			.ihf-eureka .ihf-btn.ihf-btn-primary:hover
		',
		'property' => 'border-color',
		'value'    => $core_green_dark_color . ' !important',
	);
}

if ( ! empty( $body_bg ) ) {
	$core_styles_array[] = array(
		'elements' => '
			.rh_section--props_padding:after,
			.rh_section__agents:after
		',
		'property' => 'border-left-color',
		'value'    => '#' . $body_bg,
	);
	$core_styles_array[] = array(
		'elements' => '.rh_section__agents:before',
		'property' => 'border-right-color',
		'value'    => '#' . $body_bg,
	);
}

return $core_styles_array;