<?php
/**
 * Properties Guest View Limit Template
 *
 * @since    4.4.1
 * @package  realhomes/modern
 */

get_header();

$header_variation = get_option( 'inspiry_pages_header_variation' );
if ( empty( $header_variation ) || ( 'none' === $header_variation ) ) {
	get_template_part( 'assets/modern/partials/banner/header' );
} else if ( 'banner' === $header_variation ) {
	get_template_part( 'assets/modern/partials/banner/image' );
}

// Retrieve customizable page content (title & description)
$limit_page_title    = get_option( 'realhomes_guest_properties_views_page_title' ) ? : esc_html__( 'Properties Viewing Limit Reached', RH_TEXT_DOMAIN );
$limit_page_desc     = get_option( 'realhomes_guest_properties_views_page_description' ) ? : esc_html__( 'You have reached the maximum number of property views allowed for guest users. You need to login or create an account to continue viewing more properties.', RH_TEXT_DOMAIN );

// Determine login/register page, Adjust labels, url, and classes conditionally
$login_register_page = get_option( 'inspiry_login_register_page', '' );
$login_label         = get_option( 'users_can_register' ) ? esc_html__( 'Login/Register', RH_TEXT_DOMAIN ) : esc_html__( 'Login', RH_TEXT_DOMAIN );
$login_class         = empty( $login_register_page ) ? 'ask-for-login' : '';
$login_page_url      = empty( $login_register_page ) ? home_url() : get_permalink( $login_register_page );
?>
    <section class="rh_section rh_wrap--topPadding properties-limit-wrap">
        <div class="rh_page__title">
            <h3><?php echo esc_html( $limit_page_title ); ?></h3>
        </div>

        <div class="rh_content__wrap">
            <div class="rh_alert__box rh_alert__box--warning" role="alert">
                <p><?php echo esc_html( $limit_page_desc ); ?></p>
            </div>

            <div class="rh_button_wrapper">
                <a class="rh_btn rh_btn--primary rh-login <?php echo esc_attr( $login_class ); ?>" href="<?php echo esc_url( $login_page_url ); ?>">
					<?php echo esc_html( $login_label ); ?>
                </a>
            </div>
        </div>
    </section><!-- .rh_section--flex -->

<?php
get_footer();