<?php
/**
 * Field: Number Of Properties
 *
 * Agent Locations field for agent search form.
 *
 * @since    4.0.0
 * @package  realhomes/modern
 */
$no_of_properties_placeholder_text = get_option( 'realhomes_agent_number_of_properties_placeholder', esc_html__( 'Listed Properties (Min)', RH_TEXT_DOMAIN ) );
if ( empty( $no_of_properties_placeholder_text ) ) {
	$no_of_properties_placeholder_text = esc_html__( 'Listed Properties (Min)', RH_TEXT_DOMAIN );
}
$no_of_properties_values = get_option( 'realhomes_number_of_properties_values' );
if ( empty( $no_of_properties_values ) ) {
	$no_of_properties_values = '1,2,3,4,5,6,7,8,9,10';
}

// Retain selected value if set in URL
$number_of_properties = '';
if ( isset( $_GET['number-of-properties'] ) && is_numeric( $_GET['number-of-properties'] ) ) {
	$number_of_properties = intval( $_GET['number-of-properties'] );
}
?>
<div class="rh_agent_search__option inspiry_bs_default_mod inspiry_bs_agents_listing inspiry_bs_green">
    <span class="rh_agent_search__selectwrap">
		<select name="number-of-properties" id="number-of-properties" class="rh_agent_search__locations inspiry_select_picker_trigger inspiry_select_picker_agent inspiry_select_picker_status show-tick" data-size="5">
            <option value=""><?php echo esc_html( $no_of_properties_placeholder_text ); ?></option>
            <?php
            $exploded_options = explode( ',', $no_of_properties_values );
            foreach ( $exploded_options as $option ) {
	            echo '<option value="' . esc_attr( $option ) . '" ' . selected( $number_of_properties, $option, false ) . '>' . esc_html( $option ) . '</option>';
            }
            ?>
		</select>
	</span>
</div>