<?php
/**
 * Field: Number Of Agents
 *
 * Number of Agents field for agency search form.
 *
 * @since    4.4.4
 * @package  realhomes/modern
 */

// Get placeholder text with fallback
$no_of_agents_placeholder_text = get_option(
	'realhomes_agency_agents_placeholder',
	esc_html__( 'Number of Agents', RH_TEXT_DOMAIN )
);

$no_of_agents_placeholder_text = sanitize_text_field( $no_of_agents_placeholder_text );
if ( empty( $no_of_agents_placeholder_text ) ) {
	$no_of_agents_placeholder_text = esc_html__( 'Listed Agents (Min)', RH_TEXT_DOMAIN );
}

// Get dropdown values with fallback
$no_of_agents_values = get_option( 'realhomes_agency_agents_count' );
if ( empty( $no_of_agents_values ) ) {
	$no_of_agents_values = '1,2,3,4,5,6,7,8,9,10';
}

// Split, sanitize, and keep only unique integers
$no_of_agents_values_arr = array();
if ( ! empty( $no_of_agents_values ) ) {
	$values = explode( ',', $no_of_agents_values );

	foreach ( $values as $value ) {
		$value = trim( $value );
		if ( is_numeric( $value ) ) {
			$int_value = intval( $value );
			if ( $int_value > 0 ) { // ensure positive int
				$no_of_agents_values_arr[] = $int_value;
			}
		}
	}

	// Remove duplicates and sort ascending
	$no_of_agents_values_arr = array_unique( $no_of_agents_values_arr );
	sort( $no_of_agents_values_arr, SORT_NUMERIC );
}

// Retain selected value if set in URL
$selected_agents = '';
if ( isset( $_GET['agents'] ) && is_numeric( $_GET['agents'] ) ) {
	$selected_agents = intval( $_GET['agents'] );
}
?>

<div class="rh_agency_search__option inspiry_bs_default_mod inspiry_bs_agency_listing inspiry_bs_green">
	<span class="rh_agency_search__selectwrap">
		<select name="agents" id="agents"
                class="rh_agency_search__agents inspiry_select_picker_trigger inspiry_select_picker_agency inspiry_select_picker_status show-tick"
                data-size="5">
			<option value=""><?php echo esc_html( $no_of_agents_placeholder_text ); ?></option>
			<?php foreach ( $no_of_agents_values_arr as $option ) : ?>
                <option value="<?php echo esc_attr( $option ); ?>"  <?php selected( $selected_agents, $option ); ?>>
					<?php echo esc_html( $option ); ?>
				</option>
			<?php endforeach; ?>
		</select>
	</span>
</div>
