<?php
/**
 * Containing dynamic css header style options
 *
 * @since      4.4.0
 * @package    realhomes
 * @subpackage classic
 */

$core_keys = array(
	'theme_header_bg_color',
	'theme_header_text_color',
	'theme_header_link_hover_color',
	'theme_header_border_color',
	'theme_main_menu_text_color',
	'theme_main_menu_text_hover_color',
	'theme_menu_bg_color',
	'theme_menu_text_color',
	'theme_menu_hover_bg_color',
	'theme_menu_hover_text_color',
	'theme_phone_bg_color',
	'theme_phone_text_color',
	'theme_phone_icon_bg_color',
	'theme_logo_text_color',
	'theme_logo_text_hover_color',
	'theme_tagline_text_color',
	'theme_tagline_bg_color'
);

$core_options = realhomes_get_options( $core_keys );

$theme_header_bg_color         = $core_options[ 'theme_header_bg_color' ];
$theme_header_text_color       = $core_options[ 'theme_header_text_color' ];
$theme_header_link_hover_color = $core_options[ 'theme_header_link_hover_color' ];
$theme_header_border_color     = $core_options[ 'theme_header_border_color' ];

// Drop Down Menu
$theme_main_menu_text_color       = $core_options[ 'theme_main_menu_text_color' ];
$theme_main_menu_text_hover_color = $core_options[ 'theme_main_menu_text_hover_color' ];
$theme_menu_bg_color              = $core_options[ 'theme_menu_bg_color' ];
$theme_menu_text_color            = $core_options[ 'theme_menu_text_color' ];
$theme_menu_hover_bg_color        = $core_options[ 'theme_menu_hover_bg_color' ];
$theme_menu_hover_text_color      = $core_options[ 'theme_menu_hover_text_color' ];

// Phone Icon and Number
$theme_phone_bg_color      = $core_options[ 'theme_phone_bg_color' ];
$theme_phone_text_color    = $core_options[ 'theme_phone_text_color' ];
$theme_phone_icon_bg_color = $core_options[ 'theme_phone_icon_bg_color' ];

// Logo
$theme_logo_text_color       = $core_options[ 'theme_logo_text_color' ];
$theme_logo_text_hover_color = $core_options[ 'theme_logo_text_hover_color' ];

// Tagline
$theme_tagline_text_color = $core_options[ 'theme_tagline_text_color' ];
$theme_tagline_bg_color   = $core_options[ 'theme_tagline_bg_color' ];

$header_css = array(
	'elements' => '
		.header-wrapper,
		#currency-switcher #selected-currency,
		#currency-switcher-list li
	',
	'property' => 'background-color',
	'value'    => $theme_header_bg_color,
);

$header_css = array(
	'elements' => '#logo h2 a',
	'property' => 'color',
	'value'    => $theme_logo_text_color
);

$header_css = array(
	'elements' => '
		#logo h2 a:hover,
		#logo h2 a:focus,
		#logo h2 a:active
	',
	'property' => 'color',
	'value'    => $theme_logo_text_hover_color
);

$header_css = array(
	'elements' => '.tag-line span',
	'property' => 'color',
	'value'    => $theme_tagline_text_color
);

$header_css = array(
	'elements' => '.tag-line span',
	'property' => 'background-color',
	'value'    => $theme_tagline_bg_color
);

$header_css = array(
	'elements' => '
		.header-wrapper,
		#contact-email,
		#contact-email a,
		.user-nav a,
		.social_networks li a,
		#currency-switcher #selected-currency,
		#currency-switcher-list li,
		.user-nav a:after
	',
	'property' => 'color',
	'value'    => $theme_header_text_color
);

$header_css = array(
	'elements' => '#contact-email svg .path',
	'property' => 'fill',
	'value'    => $theme_header_text_color
);

$header_css = array(
	'elements' => '
		#contact-email a:hover,
		.user-nav a:hover
	',
	'property' => 'color',
	'value'    => $theme_header_link_hover_color
);

$header_css = array(
	'elements' => '
		#header-top,
		.social_networks li a,
		.user-nav a,
		.header-wrapper .social_networks,
		#currency-switcher #selected-currency,
		#currency-switcher-list li
	',
	'property' => 'border-color',
	'value'    => $theme_header_border_color
);

$header_css = array(
	'elements' => '.main-menu ul li a',
	'property' => 'color',
	'value'    => $theme_main_menu_text_color
);

$header_css = array(
	'elements' => '
		.main-menu ul li:hover > a,
        .main-menu ul li.current-menu-item > a
    ',
	'property' => 'color',
	'value'    => $theme_main_menu_text_hover_color
);

$header_css = array(
	'elements' => '
		.main-menu ul li.current-menu-ancestor > a,
		.main-menu ul li.current-menu-parent > a,
		.main-menu ul li.current-menu-item > a,
		.main-menu ul li.current_page_item > a,
		.main-menu ul li:hover > a,
		.main-menu ul li ul,
		.main-menu ul li ul li ul
	',
	'property' => 'background-color',
	'value'    => $theme_menu_bg_color
);

$header_css = array(
	'elements' => '
		.main-menu ul li ul li.current-menu-ancestor > a, 
        .main-menu ul li ul li.current-menu-parent > a, 
        .main-menu ul li ul li.current-menu-item > a, 
        .main-menu ul li ul li.current_page_item > a, 
        .main-menu ul li ul li:hover > a, 
        .main-menu ul li ul, 
        .main-menu ul li ul li a, 
        .main-menu ul li ul li ul, 
        .main-menu ul li ul li ul li a]
    ',
	'property' => 'color',
	'value'    => $theme_menu_text_color
);

$header_css = array(
	'elements' => '.main-menu ul li ul li:hover > a, .main-menu ul li ul li ul li:hover > a',
	'property' => 'background-color',
	'value'    => $theme_menu_hover_bg_color
);

$header_css = array(
	'elements' => '.main-menu ul li ul li:hover > a, .main-menu ul li ul li ul li:hover > a',
	'property' => 'color',
	'value'    => $theme_menu_hover_text_color
);

$header_css = array(
	'elements' => '.main-menu ul li .menu-item-desc',
	'property' => 'color',
	'value'    => $theme_menu_bg_color
);

$header_css = array(
	'elements' => '.main-menu ul li .menu-item-desc',
	'property' => 'background-color',
	'value'    => $theme_menu_text_color
);

return $header_css;