<?php
/**
 * Template Name: Timeline
 */
get_header('inner');
?>


<!-- Carousel -->

<div class="rightside ">
<div class="content py-5 p-3 pl-0">
<div class="row">


    <div class="col-md-12 fluidimg">
        <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/timeline_banner.jpg" alt="Timeline">
        <div class="redbox"></div>
    </div>
</div>
<div class=" ">

     <h2 class="section-title"><?php echo get_field( "section_1_title" ); ?></h2>
<p><?php echo get_field( "section_1_content" ); ?></p>


     <h2 class="section-title"><?php echo get_field( "section_2_title" ); ?></h2>

<p class="py-2"><?php echo get_field( "section_2_content" ); ?></p>

<!-- Phased Approach -->

<div class="container">
    <div class="phased-container">
        <h5 class=" mb-4">OUR PHASED APPROACH</h5>
        <div class="row justify-content-center">
            <div class="col-md-6 d-flex flex-column align-items-center phase-step">
                <div class="phase-circle">01</div>
                <div class="phase-title"><?php echo get_field( "phase_title_1" ); ?></div>
                <div class="phase-desc"><?php echo get_field( "phase_content_1" ); ?></div>
            </div>
            <div class="col-md-6 d-flex flex-column align-items-center phase-step">
                <div class="phase-circle">02</div>
                <div class="phase-title"><?php echo get_field( "phase_title_2" ); ?></div>
                <div class="phase-desc"><?php echo get_field( "phase_content_2" ); ?></div>
            </div>
        </div>
    </div>
</div>




     <!-- How we work -->
    <div class="mt-5 p-2 ">
        <h5 class="mb-3 bg-light p-2"><?php echo get_field( "section_3_title" ); ?></h5>
        <p><?php echo get_field( "section_3_content" ); ?></p>
        <div class="row g-3 mt-2">
            <div class="col-md-6 col-12">
                <div class="work-card gray">
                    <i class="invasive"></i>
                    <span><?php echo get_field( "icon_title_1" ); ?><br><small><?php echo get_field( "icon_content_1" ); ?></small></span>
                </div>
            </div>
            <div class="col-md-6 col-12">
                <div class="work-card gray">
                    <i class="Culturally"></i>
                    <span><?php echo get_field( "icon_title_2" ); ?><br><small><?php echo get_field( "icon_content_2" ); ?></small></span>
                </div>
            </div>
            <div class="col-md-6 col-12">
                <div class="work-card gray">
                    <i class="Environmentally"></i>
                    <span><?php echo get_field( "icon_title_3" ); ?><br><small><?php echo get_field( "icon_content_3" ); ?></small></span>
                </div>
            </div>
            <div class="col-md-6 col-12">
                <div class="work-card gray">
                    <i class="edu"></i>
                    <span><?php echo get_field( "icon_title_4" ); ?><br><small><?php echo get_field( "icon_content_4" ); ?></small></span>
                </div>
            </div>
        </div>
    </div>

    <div class="mt-5 p-2 ">
        <h5 class="mb-3 bg-light p-2"><?php echo get_field( "section_4_title" ); ?></h5>
        <?php echo get_field( "section_4_content" ); ?>
        </div>

        <div class="container">
    <div class="row g-4">
        <div class="col-md-4">
            <div class="info-card red">
                <h5><?php echo get_field( "section_5_title_1" ); ?></h5>
                <p><?php echo get_field( "section_5_content_1" ); ?></p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="info-card red">
                <h5><?php echo get_field( "section_5_title_2" ); ?></h5>
                <p><?php echo get_field( "section_5_content_2" ); ?></p>
            </div>
        </div>
        <div class="col-md-4">
            <div class="info-card red">
                <h5><?php echo get_field( "section_5_title_3" ); ?></h5>
                <p><?php echo get_field( "section_5_content_3" ); ?></p>
            </div>
        </div>
    </div>
</div>



</div>

</div>
    <?php
get_footer('inner');
?>