<?php
/**
 * Template Name: Publications
 */
get_header('inner');
?>
<!-- Carousel -->

<div class="rightside ">
<div class="content py-5 p-3 pl-0">

<div class=" ">






     <!-- publications -->


      <div class="mt-1 p-2 ">
        <h5 class="mb-3 bg-light p-2">Books</h5>

        <div class="row">
<?php
// Query 'publication' posts where taxonomy = 'book_category' and term is either forthcoming OR monograph.
// Limit to first 2 posts so they appear side-by-side.
$args = array(
  'post_type'      => 'publication',
  'posts_per_page' => 2,
  'orderby'        => 'date',
  'order'          => 'DESC',
  'tax_query'      => array(
    array(
      'taxonomy' => 'book_category',
      'field'    => 'slug',
      'terms'    => array( 'forthcoming', 'monograph' ), // both terms
      'operator' => 'IN',
    ),
  ),
);

$books_query = new WP_Query($args);

if ($books_query->have_posts()) :
    $count = 0;
    echo '<div class="row">';
    while ($books_query->have_posts()) : $books_query->the_post();

        // Custom fields
        $publisher   = get_field('publisher');
        $status      = get_field('status'); // e.g. "Under Contract"
        $sub_title   = get_field('sub_title');
        $short_desc  = get_field('short_description');
        $cover       = get_the_post_thumbnail_url(get_the_ID(), 'medium');
?>
        <div class="col-md-6">
          <div class="book-section">
            <?php if ($cover): ?>
              <img src="<?php echo esc_url($cover); ?>" alt="<?php echo get_field('alt_text'); ?>" class="book-cover">
            <?php endif; ?>

            <div class="book-details three">
              <h3 class="pt-2">
                <?php the_title(); ?>
                <?php if($status): ?>
                  <span>(<?php echo esc_html($status); ?>)</span>
                <?php endif; ?>
              </h3>
              <div class="divider"></div>

              <?php if($sub_title): ?>
                <p><strong><?php echo esc_html($sub_title); ?></strong></p>
              <?php endif; ?>

              <?php if($short_desc): ?>
                <p class="publisher"><?php echo esc_html($short_desc); ?></p>
              <?php elseif($publisher): ?>
                <p class="publisher"><?php echo esc_html($publisher); ?></p>
              <?php endif; ?>
            </div>
          </div>
        </div>
<?php
        $count++;
    endwhile;
    echo '</div>'; // close row
    wp_reset_postdata();
else:
    echo '<p>No Books found.</p>';
endif;
?>
        </div>
    </div>





   <div class="mt-1 p-2 ">
        <h5 class="mb-3 bg-light p-2">Book Chapters</h5>
      
        <div class="row">

<?php 
// Query 'publication' posts where taxonomy = 'Book Chapters'
$args = array(
  'post_type'      => 'publication',
  'posts_per_page' => -1,
  'orderby'        => 'date',
  'order'          => 'DESC',
  'tax_query'      => array(
    array(
      'taxonomy' => 'book_category', // replace with your actual taxonomy name
      'field'    => 'slug',
      'terms'    => 'book_chapters', // use slug, not label
    ),
  ),
);

$query = new WP_Query($args);

if ($query->have_posts()) : 
  $count = 0; // track columns
  echo '<div class="row">';
  
  while ($query->have_posts()) : $query->the_post();

    // Custom fields
    $publisher   = get_field('publisher');
    $status      = get_field('status'); // e.g. "Under Contract"
    $sub_title   = get_field('sub_title');
    $short_desc  = get_field('short_description');
    $cover       = get_the_post_thumbnail_url(get_the_ID(), 'medium'); 
?>
    <div class="col-md-6">
      <div class="book-section">
        
        <!-- Book Cover -->
        <?php if ($cover): ?>
          <img src="<?php echo esc_url($cover); ?>" alt="<?php echo get_field('alt_text'); ?>" class="book-cover">
        <?php endif; ?>

        <!-- Book Details -->
        <div class="book-details three">
          <h3 class="pt-2">
            <?php the_title(); ?>
            <?php if($status): ?>
              <span>(<?php echo esc_html($status); ?>)</span>
            <?php endif; ?>
          </h3>
          <div class="divider"></div>

          <?php if($sub_title): ?>
            <p><strong><?php echo esc_html($sub_title); ?></strong></p>
          <?php endif; ?>

          <?php if($short_desc): ?>
            <p class="publisher"><?php echo esc_html($short_desc); ?></p>
          <?php elseif($publisher): ?>
            <p class="publisher"><?php echo esc_html($publisher); ?></p>
          <?php endif; ?>
        </div>
      </div>
    </div>
<?php 
    $count++;
    // Close row after 2 items and start a new one
    if ($count % 2 == 0) {
      echo '</div><div class="row">';
    }

  endwhile;
  echo '</div>'; // close last row

  wp_reset_postdata();
else: 
  echo "<p>No Book Chapters found.</p>";
endif;
?>



        </div>


    </div>

   <div class="mt-1 p-2 ">
        <h5 class="mb-3 bg-light p-2">Refereed Journal Articles</h5>

                <div class="row">

<?php 
// Query 'publication' posts where taxonomy = 'refereed_journal_articles'
$args = array(
  'post_type'      => 'publication',
  'posts_per_page' => -1,
  'orderby'        => 'date',
  'order'          => 'DESC',
  'tax_query'      => array(
    array(
      'taxonomy' => 'book_category', // replace with your actual taxonomy name
      'field'    => 'slug',
      'terms'    => 'refereed_journal_articles', // use slug, not label
    ),
  ),
);

$query = new WP_Query($args);

if ($query->have_posts()) : 
  $count = 0; // track columns
  echo '<div class="row">';
  
  while ($query->have_posts()) : $query->the_post();

    // Custom fields
    $publisher   = get_field('publisher');
    $status      = get_field('status'); // e.g. "Under Contract"
    $sub_title   = get_field('sub_title');
    $short_desc  = get_field('short_description');
    $cover       = get_the_post_thumbnail_url(get_the_ID(), 'medium'); 
?>
    <div class="col-md-6">
      <div class="book-section">
        
        <!-- Book Cover -->
        <?php if ($cover): ?>
          <img src="<?php echo esc_url($cover); ?>" alt="<?php echo get_field('alt_text'); ?>" class="book-cover">
        <?php endif; ?>

        <!-- Book Details -->
        <div class="book-details three">
          <h3 class="pt-2">
            <?php the_title(); ?>
            <?php if($status): ?>
              <span>(<?php echo esc_html($status); ?>)</span>
            <?php endif; ?>
          </h3>
          <div class="divider"></div>

          <?php if($sub_title): ?>
            <p><strong><?php echo esc_html($sub_title); ?></strong></p>
          <?php endif; ?>

          <?php if($short_desc): ?>
            <p class="publisher"><?php echo esc_html($short_desc); ?></p>
          <?php elseif($publisher): ?>
            <p class="publisher"><?php echo esc_html($publisher); ?></p>
          <?php endif; ?>
        </div>
      </div>
    </div>
<?php 
    $count++;
    // Close row after 2 items and start a new one
    if ($count % 2 == 0) {
      echo '</div><div class="row">';
    }

  endwhile;
  echo '</div>'; // close last row

  wp_reset_postdata();
else: 
  echo "<p>No refereed_journal_articles found.</p>";
endif;
?>



        </div>

    </div>


</div>

</div>

    <?php
get_footer('inner');
?>